#ifndef TEXTURE_SECTION_H
#define TEXTURE_SECTION_H

#include <d3d8.h>


struct tTextureSection
{

  enum eFlags
  {
    TSF_DEFAULT       = 0x00000000,
    TSF_ROTATE_90     = 0x00000001,
    TSF_ROTATE_180    = 0x00000002,
    TSF_ROTATE_270    = 0x00000003,
    TSF_H_MIRROR      = 0x00000004,
    TSF_V_MIRROR      = 0x00000008,
    TSF_HCENTER       = 0x00000010,
    TSF_VCENTER       = 0x00000020,
    TSF_ALIGN_BOTTOM  = 0x00000040,
    TSF_ALIGN_RIGHT   = 0x00000080,

    TSF_CENTERED    = TSF_HCENTER | TSF_VCENTER,
  };

  IDirect3DTexture8*        m_pTexture;
  int                       m_iWidth,
                            m_iHeight,
                            m_iXOffset,
                            m_iYOffset;
  float                     m_fTU[2],
                            m_fTV[2];
  DWORD                     m_Flags;


  tTextureSection( IDirect3DTexture8* pTexture = NULL, int iX = 0, int iY = 0, int iWidth = -1, int iHeight = -1, DWORD dwFlags = 0 ) :
    m_pTexture( pTexture ),
    m_iWidth( iWidth ),
    m_iHeight( iHeight ),
    m_iXOffset( iX ),
    m_iYOffset( iY ),
    m_Flags( dwFlags )
  {
    if ( ( m_pTexture )
    &&   ( iWidth == -1 )
    &&   ( iHeight == -1 ) )
    {
      m_iWidth  = 256;
      m_iHeight = 256;
    }
    if ( m_iWidth == -1 )
    {
      m_iWidth = 0;
    }
    if ( m_iHeight == -1 )
    {
      m_iHeight = 0;
    }
    CalcTexCoords();
  }

  void CalcTexCoords()
  {
    if ( m_pTexture )
    {
      m_fTU[0] = (float)m_iXOffset / 256.0f;
      m_fTV[0] = (float)m_iYOffset / 256.0f;
      m_fTU[1] = (float)( m_iXOffset + m_iWidth ) / 256.0f;
      m_fTV[1] = (float)( m_iYOffset + m_iHeight ) / 256.0f;
    }
    else
    {
      m_fTU[0] = 0.0f;
      m_fTV[0] = 0.0f;
      m_fTU[1] = 0.0f;
      m_fTV[1] = 0.0f;
    }
  }

};

#endif // TEXTURE_SECTION_H