#pragma once

#include <list>
#include <vector>
#include <map>

#include "GameObject.h"



class CGSGame;

class Level
{

  public:

    typedef std::multimap<float,GameObject*>   tListObjects;

    tListObjects            m_Objects;

    float                   m_PhysicsStep;

    std::string             m_Name;

    int                     m_ObjIndex;

    float                         m_DisplayOffset;

    std::set<LD14::SoundTypes>    m_SoundRequests;

    CGSGame*                m_pGSGame;

    float                   m_Length;

    float                   m_LeftWallX;
    float                   m_RightWallX;

    GameObject*             m_pPlayer;


    Level();
    ~Level();


    void                    Render();
    void                    Update( float ElapsedTime );

    bool                    Load( int Nr );

    void                    Clear();

    void                    PlayRequestedSounds();

    bool                    CheckCollision( GameObject* pObject, float DeltaY );

    void                    Add( GameObject* pObj );
    void                    UpdateObjectPos( GameObject* pObj, float DeltaY );

};
