#include ".\level.h"
#include ".\LD14.h"
#include ".\GSGame.h"

#include <string>



Level::Level() :
  m_DisplayOffset( 0.0f ),
  m_pGSGame( NULL ),
  m_Length( 100.0f )
{

  Clear();

}



Level::~Level()
{
}



void Level::Render()
{

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG1 );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1 );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_ZWRITEENABLE, TRUE );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_ZENABLE, TRUE );

  theApp.m_pd3dDevice->SetRenderState( D3DRS_FOGENABLE, TRUE );
  //theApp.m_pd3dDevice->SetRenderState( D3DRS_RANGEFOGENABLE, TRUE );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_FOGVERTEXMODE, D3DFOG_LINEAR  );

  theApp.m_pd3dDevice->SetRenderState( D3DRS_FOGCOLOR, 0xff757E85 );

  float     FogStart  = 5.0f;
  float     FogEnd    = 10.0f;
  theApp.m_pd3dDevice->SetRenderState( D3DRS_FOGSTART, *((DWORD*)( &FogStart ) ) );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_FOGEND, *((DWORD*)( &FogEnd ) ) );

  // render floor
  theApp.m_pd3dDevice->SetTexture( 0, theApp.m_pTextureFloor );

  float       Delta = fmodf( m_DisplayOffset, 1.0f );

  float       DisplayOffset = (float)(int)( m_DisplayOffset );

  // draw two parts for everything for the fog to work nicely
  theApp.RenderQuad( D3DXVECTOR3( -10.0f, -4.0f - DisplayOffset, 0.0f ),
                     D3DXVECTOR3( 10.0f, -4.0f - DisplayOffset, 0.0f ),
                     D3DXVECTOR3( -10.0f, 1.0f - DisplayOffset, 0.0f ),
                     D3DXVECTOR3( 10.0f, 1.0f - DisplayOffset, 0.0f ),
                     -10.0f, -4.0f,
                     10.0f, -4.0f,
                     -10.0f, 1.0f,
                     10.0f, 1.0f,
                     0xffffffff );
  theApp.RenderQuad( D3DXVECTOR3( -10.0f, -10.0f - DisplayOffset, 0.0f ),
                     D3DXVECTOR3( 10.0f, -10.0f - DisplayOffset, 0.0f ),
                     D3DXVECTOR3( -10.0f, -4.0f - DisplayOffset, 0.0f ),
                     D3DXVECTOR3( 10.0f, -4.0f - DisplayOffset, 0.0f ),
                     -10.0f, -10.0f,
                     10.0f, -10.0f,
                     -10.0f, -4.0f,
                     10.0f, -4.0f,
                     0xffffffff );

  // and walls
  theApp.m_pd3dDevice->SetTexture( 0, theApp.m_pTextureWall );

  theApp.RenderQuad( D3DXVECTOR3( m_LeftWallX, 1.0f - DisplayOffset, 1.6f ),
                     D3DXVECTOR3( m_LeftWallX, -4.0f - DisplayOffset, 1.6f ),
                     D3DXVECTOR3( m_LeftWallX, 1.0f - DisplayOffset, 0.0f ),
                     D3DXVECTOR3( m_LeftWallX, -4.0f - DisplayOffset, 0.0f ),
                     -4.0f, 0.0f,
                     1.0f, 0.0f,
                     -4.0f, 1.0f,
                     1.0f, 1.0f,
                     0xffffffff );
  theApp.RenderQuad( D3DXVECTOR3( m_LeftWallX, -4.0f - DisplayOffset, 1.6f ),
                     D3DXVECTOR3( m_LeftWallX, -10.0f - DisplayOffset, 1.6f ),
                     D3DXVECTOR3( m_LeftWallX, -4.0f - DisplayOffset, 0.0f ),
                     D3DXVECTOR3( m_LeftWallX, -10.0f - DisplayOffset, 0.0f ),
                     -10.0f, 0.0f,
                     -4.0f, 0.0f,
                     -10.0f, 1.0f,
                     -4.0f, 1.0f,
                     0xffffffff );

  theApp.RenderQuad( D3DXVECTOR3( m_RightWallX, -4.0f - DisplayOffset, 1.6f ),
                     D3DXVECTOR3( m_RightWallX, 1.0f - DisplayOffset, 1.6f ),
                     D3DXVECTOR3( m_RightWallX, -4.0f - DisplayOffset, 0.0f ),
                     D3DXVECTOR3( m_RightWallX, 1.0f - DisplayOffset, 0.0f ),
                     -4.0f, 0.0f,
                     1.0f, 0.0f,
                     -4.0f, 1.0f,
                     1.0f, 1.0f,
                     0xffffffff );
  theApp.RenderQuad( D3DXVECTOR3( m_RightWallX, -10.0f - DisplayOffset, 1.6f ),
                     D3DXVECTOR3( m_RightWallX, -4.0f - DisplayOffset, 1.6f ),
                     D3DXVECTOR3( m_RightWallX, -10.0f - DisplayOffset, 0.0f ),
                     D3DXVECTOR3( m_RightWallX, -4.0f - DisplayOffset, 0.0f ),
                     -10.0f, 0.0f,
                     -4.0f, 0.0f,
                     -10.0f, 1.0f,
                     -4.0f, 1.0f,
                     0xffffffff );

  // Render Objects
  tListObjects::iterator it = m_Objects.lower_bound( -m_DisplayOffset - 20.0f );
  while ( it != m_Objects.end() )
  {
    if ( it->first >= -m_DisplayOffset + 2.0f )
    {
      break;
    }

    GameObject& Obj( *it->second );

    Obj.Render( *this );

    ++it;
  }

  // Render FX
  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ZWRITEENABLE, FALSE );

  // Render Objects
  it = m_Objects.begin();
  while ( it != m_Objects.end() )
  {
    GameObject& Obj( *it->second );

    Obj.RenderFX( *this );

    ++it;
  }

  theApp.m_pd3dDevice->SetRenderState( D3DRS_FOGENABLE, FALSE );

}



void Level::Update( float ElapsedTime )
{

  m_PhysicsStep += ElapsedTime;

  while ( m_PhysicsStep >= 0.02f )
  {
    tListObjects::iterator    it( m_Objects.begin() );
    while ( it != m_Objects.end() )
    {
      GameObject& Obj( *it->second );

      Obj.UpdatePhysicsStep( *this );
      if ( Obj.m_RemoveMe )
      {
        delete &Obj;
        it = m_Objects.erase( it );
      }
      else
      {
        ++it;
      }
    }
    m_PhysicsStep -= 0.02f;
  }

  tListObjects::iterator    it( m_Objects.begin() );
  while ( it != m_Objects.end() )
  {
    GameObject& Obj( *it->second );

    Obj.Update( ElapsedTime, *this );
    if ( Obj.m_RemoveMe )
    {
      delete &Obj;
      it = m_Objects.erase( it );
    }
    else
    {
      ++it;
    }
  }

  it = m_Objects.begin();
  while ( it != m_Objects.end() )
  {
    GameObject&   Obj( *it->second );

    ++it;
  }

  PlayRequestedSounds();

}



void Level::PlayRequestedSounds()
{

  std::set<LD14::SoundTypes>::iterator    itSound( m_SoundRequests.begin() );
  while ( itSound != m_SoundRequests.end() )
  {
    theApp.PlaySound( *itSound );

    ++itSound;
  }
  m_SoundRequests.clear();

}



void Level::Clear()
{

  m_PhysicsStep         = 0.0f;

  tListObjects::iterator   it( m_Objects.begin() );
  while ( it != m_Objects.end() )
  {
    delete it->second;


    ++it;
  }

  m_Objects.clear();
  m_SoundRequests.clear();

  m_Name.erase();
  m_ObjIndex = 1;

  m_LeftWallX   = -1.1f;
  m_RightWallX  = 1.1f;

  m_DisplayOffset = 0.0f;
  m_pPlayer       = NULL;

}



bool Level::Load( int Nr )
{

  Clear();

  char    Temp[260];

  wsprintf( Temp, "data\\level%d.dat", Nr );

  FILE*   In = fopen( Temp, "r" );
  if ( In == NULL )
  {
    return false;
  }

  std::set<GameObject*>   SetFlags;

  float   CurY = 0.0f;

  char    line[1024];       
  while ( fgets ( line, sizeof( line ), In ) != NULL ) 
  {
    std::string     Line = line;

    if ( !Line.empty() )
    {
      // object wall,-1.0,5
      size_t    SpacePos = Line.find( ' ' );
      if ( SpacePos != std::string::npos )
      {
        std::string     Command = Line.substr( 0, SpacePos );

        std::string     Params = Line.substr( SpacePos + 1 );

        std::list<std::string>    ParamList;

        size_t    KommaStartPos = 0;
        size_t    KommaPos = 0;
        while ( ( KommaPos = Params.find( ',', KommaStartPos ) ) != std::string::npos )
        {
          ParamList.push_back( Params.substr( KommaStartPos, KommaPos - KommaStartPos ) );
          KommaStartPos = KommaPos + 1;
        }
        if ( KommaStartPos < Params.length() )
        {
          ParamList.push_back( Params.substr( KommaStartPos ) );
        }

        std::list<std::string>::iterator    itParam( ParamList.begin() );

        if ( Command == "y" )
        {
          if ( ParamList.size() == 1 )
          {
            CurY = (float)atof( itParam->c_str() );
          }
        }
        else if ( Command == "length" )
        {
          if ( ParamList.size() == 1 )
          {
            m_Length = (float)atof( itParam->c_str() );
          }
        }
        else if ( Command == "object" )
        {
          if ( ParamList.size() == 3 )
          {
            int             ObjValue3 = 0;

            std::string     ObjType = *itParam;

            ++itParam;
            float           ObjX = (float)atof( itParam->c_str() );

            ++itParam;
            float           ObjZ = (float)atof( itParam->c_str() );

            LD14::GameObjectType    GOType = LD14::GO_INVALID;

            if ( ObjType == "flagr" )
            {
              GOType = LD14::GO_FLAG_R;
            }
            else if ( ObjType == "flagb" )
            {
              GOType = LD14::GO_FLAG_B;
            }
            else if ( ObjType == "flagy" )
            {
              GOType = LD14::GO_FLAG_Y;
            }
            else if ( ObjType == "flagg" )
            {
              GOType = LD14::GO_FLAG_G;
            }
            else if ( ObjType == "flagv" )
            {
              GOType = LD14::GO_FLAG_V;
            }
            else if ( ObjType == "flag" )
            {
              GOType = LD14::GO_FLAG;
            }
            else if ( ObjType == "note" )
            {
              GOType = LD14::GO_NOTE;
            }
            else if ( ObjType == "wall" )
            {
              GOType = LD14::GO_WALL;
            }
            else if ( ObjType == "spike" )
            {
              GOType = LD14::GO_SPIKE;
            }
            else if ( ObjType == "autospike" )
            {
              GOType = LD14::GO_SPIKE;
              ObjValue3 = 1;
            }
            else if ( ObjType == "fence" )
            {
              GOType = LD14::GO_FENCE;
            }
            else if ( ObjType == "present" )
            {
              GOType = LD14::GO_PRESENT;
            }
            else if ( ObjType == "boards" )
            {
              GOType = LD14::GO_BOARDS;
            }
            else if ( ObjType == "goal" )
            {
              GOType = LD14::GO_GOAL;
            }
            else if ( ObjType == "pole" )
            {
              GOType = LD14::GO_POLE;
            }
            else if ( ObjType == "polev" )
            {
              GOType = LD14::GO_POLE;
              ObjValue3 = 1;
            }
            else if ( ObjType == "spikeball" )
            {
              GOType = LD14::GO_SPIKE_BALL;
            }
            else if ( ObjType == "speedup" )
            {
              GOType = LD14::GO_SPEEDUP;
            }
            else
            {
              //dh::Log( "Unknown Object: %s", ObjType.c_str() );
            }
            if ( GOType != LD14::GO_INVALID )
            {
              GameObject*   pObj = new GameObject( GOType, ObjX, -CurY, ObjZ );
              Add( pObj );
              pObj->m_Value3 = ObjValue3;
              if ( GOType == LD14::GO_FLAG )
              {
                SetFlags.insert( pObj );
              }
            }
          }
        }
      }
    }
  }

  fclose( In );

  int     FlagColors[5];

  int     FlagsToSet = (int)SetFlags.size();

  for ( int i = 0; i < 5; ++i )
  {
    FlagColors[i] = (int)SetFlags.size() / 5;
    FlagsToSet -= (int)SetFlags.size() / 5;
  }
  while ( FlagsToSet > 0 )
  {
    FlagColors[rand() % 5]++;
    FlagsToSet--;
  }

  std::set<GameObject*>::iterator    itO( SetFlags.begin() );
  while ( itO != SetFlags.end() )
  {
    while ( true )
    {
      int   Rand = rand() % 5;

      if ( FlagColors[Rand] != 0 )
      {
        GameObject*   pObj( *itO );

        pObj->m_Texture = (LD14::TextureTypes)( LD14::TEX_FLAG_R + Rand );
        pObj->m_Type    = (LD14::GameObjectType)( LD14::GO_FLAG_R + Rand );
        --FlagColors[Rand];
        break;
      }
    }

    ++itO;
  }

  return true;

}



bool Level::CheckCollision( GameObject* pObject, float DeltaY )
{

  bool    Blocked = false;

  float   UpperEnd = pObject->m_Pos.y + DeltaY;
  float   LowerEnd = pObject->m_Pos.y;

  if ( DeltaY > 0.0f )
  {
    std::swap( UpperEnd, LowerEnd );
  }


  tListObjects::iterator   it( m_Objects.upper_bound( UpperEnd ) );
  while ( it != m_Objects.end() )
  {
    GameObject&   Obj2( *it->second );

    if ( ( it == m_Objects.end() )
    ||   ( it->first > LowerEnd ) )
    {
      break;
    }

    if ( &Obj2 != pObject )
    {
      // check
      if ( ( pObject->m_Pos.x + pObject->m_Size.x >= Obj2.m_Pos.x )
      &&   ( Obj2.m_Pos.x + Obj2.m_Size.x >= pObject->m_Pos.x )
      &&   ( pObject->m_Pos.z <= Obj2.m_Pos.z + Obj2.m_Size.y )
      &&   ( Obj2.m_Pos.z <= pObject->m_Pos.z + pObject->m_Size.y ) )
      {
        // collision!
        if ( m_pGSGame )
        {
          Blocked |= m_pGSGame->OnCollision( *pObject, Obj2 );
          Blocked |= m_pGSGame->OnCollision( Obj2, *pObject );
        }
      }
    }


    ++it;
    if ( ( it == m_Objects.end() )
    ||   ( it->first > LowerEnd ) )
    {
      break;
    }
  }

  if ( Blocked )
  {
    return true;
  }


  UpdateObjectPos( pObject, DeltaY );

  return false;

}



void Level::Add( GameObject* pObj )
{

  if ( pObj == NULL )
  {
    return;
  }
  m_Objects.insert( std::make_pair( pObj->m_Pos.y, pObj ) );

}



void Level::UpdateObjectPos( GameObject* pObject, float DeltaY )
{

  float     NewPos = pObject->m_Pos.y + DeltaY;

  float     UpperEnd = pObject->m_Pos.y + DeltaY;
  float     LowerEnd = pObject->m_Pos.y;

  if ( DeltaY > 0.0f )
  {
    std::swap( UpperEnd, LowerEnd );
  }

  tListObjects::iterator   it( m_Objects.lower_bound( UpperEnd ) );
  while ( it != m_Objects.end() )
  {
    GameObject&   Obj2( *it->second );

    if ( &Obj2 == pObject )
    {
      it = m_Objects.erase( it );

      pObject->m_Pos.y = NewPos;
      m_Objects.insert( std::make_pair( NewPos, pObject ) );
      return;
    }
    ++it;
    if ( it != m_Objects.end() )
    {
      if ( DeltaY < 0.0f )
      {
        if ( it->first > LowerEnd )
        {
          break;
        }
      }
      else
      {
        if ( it->first < LowerEnd )
        {
          break;
        }
      }
    }
  }

  //dh::Log( "uh oh!" );

}



