#pragma once

#include <set>
#include <list>


#include "LD14Types.h"

#include <d3dx8.h>



class Level;

class GameObject
{

  public:

    D3DXVECTOR3             m_Pos;
    D3DXVECTOR3             m_Size;

    bool                    m_RemoveMe;

    float                   m_Angle;

    LD14::TextureTypes      m_Texture;

    LD14::GameObjectType    m_Type;

    int                     m_Value1;
    int                     m_Value2;
    int                     m_Value3;

    float                   m_ValueF1;
    float                   m_ValueF2;
    float                   m_ValueF3;

    bool                    m_HasShadow;

    float                   m_ShadowOffset;


    GameObject( LD14::GameObjectType Type = LD14::GO_INVALID, float X = 0.0f, float Y = 0.0f, float Z = 0.0f );
    ~GameObject();

    void                    Render( Level& theLevel );
    void                    RenderFX( Level& theLevel );
    void                    Update( float ElapsedTime, Level& theLevel );
    void                    UpdatePhysicsStep( Level& theLevel );

};
