#include ".\gameobject.h"
#include ".\LD14.h"
#include ".\Level.h"



GameObject::GameObject( LD14::GameObjectType Type, float X, float Y, float Z ) :
  m_Texture( LD14::TEX_PLAYER_RUN_1 ),
  m_RemoveMe( false ),
  m_Pos( X, Y, Z ),
  m_Size( 0.2f, 0.2f, 0.0f ),
  m_Angle( 0.0f ),
  m_Type( Type ),
  m_Value1( 0 ),
  m_Value2( 0 ),
  m_Value3( 0 ),
  m_ValueF1( 0.0f ),
  m_ValueF2( 0.0f ),
  m_ValueF3( 0.0f ),
  m_HasShadow( true ),
  m_ShadowOffset( 0.0f )
{

  switch ( Type )
  {
    case LD14::GO_PLAYER:
      m_Size.x = 0.2f;
      m_Size.y = 0.4f;
      m_Texture = LD14::TEX_PLAYER_RUN_1;
      break;
    case LD14::GO_PLAYER_STAND:
      m_Size.x = 0.2f;
      m_Size.y = 0.4f;
      m_Texture = LD14::TEX_PLAYER_STAND_1;
      break;
    case LD14::GO_WALL:
      m_Size.x = 0.2f;
      m_Size.y = 0.2f;
      m_Texture = LD14::TEX_BRICK_WALL;
      m_HasShadow = false;
      break;
    case LD14::GO_FENCE:
      m_Size.x = 0.3f;
      m_Size.y = 0.3f;
      m_Texture = LD14::TEX_FENCE;
      m_HasShadow = false;
      break;
    case LD14::GO_FLAG_B:
      m_Size.x = 0.14f;
      m_Size.y = 0.14f;
      m_Texture = LD14::TEX_FLAG_B;
      m_ShadowOffset = -0.02f;
      break;
    case LD14::GO_FLAG_Y:
      m_Size.x = 0.14f;
      m_Size.y = 0.14f;
      m_Texture = LD14::TEX_FLAG_Y;
      m_ShadowOffset = -0.02f;
      break;
    case LD14::GO_FLAG_R:
      m_Size.x = 0.14f;
      m_Size.y = 0.14f;
      m_Texture = LD14::TEX_FLAG_R;
      m_ShadowOffset = -0.02f;
      break;
    case LD14::GO_FLAG_G:
      m_Size.x = 0.14f;
      m_Size.y = 0.14f;
      m_Texture = LD14::TEX_FLAG_G;
      m_ShadowOffset = -0.02f;
      break;
    case LD14::GO_FLAG_V:
      m_Size.x = 0.14f;
      m_Size.y = 0.14f;
      m_Texture = LD14::TEX_FLAG_V;
      m_ShadowOffset = -0.02f;
      break;
    case LD14::GO_FLAG:
      m_Size.x = 0.14f;
      m_Size.y = 0.14f;
      m_ShadowOffset = -0.02f;
      break;
    case LD14::GO_NOTE:
      m_Size.x = 0.14f;
      m_Size.y = 0.10f;
      m_Texture = LD14::TEX_NOTE;
      break;
    case LD14::GO_SPIKE:
      m_Size.x = 0.10f;
      m_Size.y = 0.14f;
      m_Texture = LD14::TEX_SPIKE;
      break;
    case LD14::GO_PRESENT:
      m_Size.x = 0.3f;
      m_Size.y = 0.3f;
      m_Texture = LD14::TEX_PRESENT;
      break;
    case LD14::GO_BOARDS:
      m_Size.x = 0.21f;
      m_Size.y = 0.21f;
      m_Texture = LD14::TEX_BOARDS;
      m_Pos.z -= 0.005f;
      m_HasShadow = false;
      break;
    case LD14::GO_GOAL:
      m_Size.x = 2.2f;
      m_Size.y = 0.21f;
      m_Texture = LD14::TEX_GOAL;
      m_HasShadow = false;
      break;
    case LD14::GO_POLE:
      m_Size.x = 2.2f;
      m_Size.y = 0.046f;
      m_Texture = LD14::TEX_POLE;
      m_HasShadow = false;
      break;
    case LD14::GO_SPIKE_BALL:
      m_Size.x = 0.14f;
      m_Size.y = 0.14f;
      m_Texture = LD14::TEX_SPIKE_BALL;
      break;
    case LD14::GO_SPEEDUP:
      m_Size.x = 0.14f;
      m_Size.y = 0.14f;
      m_Texture = LD14::TEX_SPEEDUP;
      break;
  }

}



GameObject::~GameObject(void)
{
}



void GameObject::Render( Level& theLevel )
{

  //theApp.RenderTextureSectionRotated2d( (int)m_PosX, (int)m_PosY, theApp.m_TexSec[m_Texture], m_Angle );

  D3DXVECTOR3   Base( m_Pos );
  D3DXVECTOR3   HalfSize( m_Size * 0.5f );

  theApp.RenderTextureSection( D3DXVECTOR3( Base.x - HalfSize.x, Base.y, Base.z + m_Size.y ),
                               D3DXVECTOR3( Base.x + HalfSize.x, Base.y, Base.z + m_Size.y ),
                               D3DXVECTOR3( Base.x - HalfSize.x, Base.y, Base.z ),
                               D3DXVECTOR3( Base.x + HalfSize.x, Base.y, Base.z ),
                               theApp.m_TexSec[m_Texture],
                               0xffffffff );

}



void GameObject::RenderFX( Level& theLevel )
{

  if ( m_HasShadow )
  {
    D3DXVECTOR3   Base( m_Pos );

    const float   ShadowSizeX = 0.06f;
    const float   ShadowSizeY = 0.022f;

    theApp.RenderTextureSection( D3DXVECTOR3( Base.x - ShadowSizeX, Base.y - ShadowSizeY, 0.001f ),
                                 D3DXVECTOR3( Base.x + ShadowSizeX, Base.y - ShadowSizeY, 0.001f ),
                                 D3DXVECTOR3( Base.x - ShadowSizeX, Base.y + ShadowSizeY, 0.001f ),
                                 D3DXVECTOR3( Base.x + ShadowSizeX, Base.y + ShadowSizeY, 0.001f ),
                                 theApp.m_TexSec[LD14::TEX_SHADOW],
                                 0xffffffff );
  }

}



void GameObject::Update( float ElapsedTime, Level& theLevel )
{

  switch ( m_Type )
  {
    case LD14::GO_SPIKE_BALL:
      if ( m_Value1 == 0 )
      {
        m_Pos.x -= 1.0f * ElapsedTime;
        if ( m_Pos.x <= -1.1f )
        {
          m_Pos.x = -1.1f;
          m_Value1 = 1;
        }
      }
      else if ( m_Value1 == 1 )
      {
        m_Pos.x += 1.0f * ElapsedTime;
        if ( m_Pos.x >= 1.1f )
        {
          m_Pos.x = 1.1f;
          m_Value1 = 0;
        }
      }
      break;
    case LD14::GO_POLE:
      if ( m_Value3 == 1 )
      {
        if ( m_Value1 == 1 )
        {
          m_Pos.z -= 1.0f * ElapsedTime;
          if ( m_Pos.z <= 0.0f )
          {
            m_Pos.z = 0.0f;
            m_Value1 = 0;
          }
        }
        else if ( m_Value1 == 0 )
        {
          m_Pos.z += 1.0f * ElapsedTime;
          if ( m_Pos.z >= 1.1f )
          {
            m_Pos.z = 1.1f;
            m_Value1 = 1;
          }
        }
      }
      break;
    case LD14::GO_SPIKE:
      if ( m_Value3 == 1 )
      {
        if ( theLevel.m_pPlayer->m_Pos.x < m_Pos.x )
        {
          m_Pos.x -= 0.5f * ElapsedTime;
          if ( m_Pos.x < theLevel.m_pPlayer->m_Pos.x )
          {
            m_Pos.x = theLevel.m_pPlayer->m_Pos.x;
          }
        }
        else if ( theLevel.m_pPlayer->m_Pos.x > m_Pos.x )
        {
          m_Pos.x += 0.5f * ElapsedTime;
          if ( m_Pos.x > theLevel.m_pPlayer->m_Pos.x )
          {
            m_Pos.x = theLevel.m_pPlayer->m_Pos.x;
          }
        }
      }
      break;
  }

}



void GameObject::UpdatePhysicsStep( Level& theLevel )
{

  switch ( m_Type )
  {
    case LD14::GO_PLAYER_STAND:
      m_Value1++;
      if ( m_Value1 > 32 )
      {
        m_Value1 = 0;
        m_Texture = LD14::TEX_PLAYER_STAND_1;
      }
      else if ( m_Value1 > 24 )
      {
        m_Texture = LD14::TEX_PLAYER_STAND_2;
      }
      break;
    case LD14::GO_PLAYER:
      m_Value1++;
      if ( m_Value1 > 10 )
      {
        m_Value1 -= 10;
        int Tex = m_Texture + 1;
        if ( Tex > LD14::TEX_PLAYER_RUN_4 )
        {
          m_Texture = LD14::TEX_PLAYER_RUN_1;
        }
        else
        {
          m_Texture = (LD14::TextureTypes)Tex;
        }
      }
      if ( m_Value2 & 1 )
      {
        // jumping
        m_ValueF1 += 0.02f;

        if ( m_ValueF1 >= 1.0f )
        {
          m_ValueF1 = 0.0f;
          m_Pos.z = 0.0f;
          m_Value2 &= ~1;
          theLevel.m_SoundRequests.insert( LD14::SOUND_LAND );
        }
        else
        {
          m_Pos.z = 0.5f * sinf( D3DXToRadian( m_ValueF1 * 180.0f / 1.0f ) );
        }
      }
      break;
  }

}