#include <d3d8.h>

#include ".\gsmenu.h"
#include ".\LD14.h"
#include ".\GSGame.h"
#include ".\GSInstructions.h"



CGSMenu::CGSMenu() :
  m_ButtonReleased( true )
{

  m_Level.Load( 1 );

}

CGSMenu::~CGSMenu(void)
{
}



void CGSMenu::Display( IDirect3DDevice8* pDevice )
{

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHATESTENABLE, TRUE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

  D3DXMATRIX      MatWorld;  
  D3DXMATRIX      MatView;  
  D3DXMATRIX      MatProj;  

  D3DXMatrixIdentity( &MatWorld );
  D3DXMatrixLookAtLH( &MatView, 
                      &D3DXVECTOR3( 0.0f, 1.0f, 0.64f ),
                      &( D3DXVECTOR3( 0.0f, 1.0f, 0.64f ) + D3DXVECTOR3( 0.0f, -5.0f, 0.0f ) ),
                      &D3DXVECTOR3( 0.0f, 0.0f, 1.0f ) );

  D3DXMatrixPerspectiveFovLH( &MatProj, D3DXToRadian( 90 ), 640.0f / 480.0f, 0.01f, 100.0f );

  pDevice->SetTransform( D3DTS_WORLD, &MatWorld );
  pDevice->SetTransform( D3DTS_VIEW, &MatView );
  pDevice->SetTransform( D3DTS_PROJECTION, &MatProj );

  m_Level.Render();

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

  theApp.PrintNiceCentered( 321, 71, "DOOM RUNNER", 0xff000000 );
  theApp.PrintNiceCentered( 320, 70, "DOOM RUNNER" );
  theApp.PrintNiceCentered( 321, 101, "ADVANCING WALL OF DOOM", 0xff000000 );
  theApp.PrintNiceCentered( 320, 100, "ADVANCING WALL OF DOOM", 0xffffd000 );

  theApp.PrintNiceCentered( 320, 160, "Ludum Dare #14" );
  theApp.PrintNiceCentered( 320, 190, "Georg \"Endurion\" Rottensteiner" );

  theApp.PrintNiceCentered( 320, 250, "http://www.georg-rottensteiner.de" );

  theApp.RenderButton( 320 - 5 - 120 - 10 - 120, 380, 120, 40, LD14::TEX_GUI_BUTTON_1, LD14::TEX_GUI_BUTTON_2, LD14::TEX_GUI_BUTTON_3 );
  theApp.PrintNiceCentered( 320 - 5 - 120 - 10 - 120 + 60, 385, "P PLAY" );

  theApp.RenderButton( 320 - 60, 380, 120, 40, LD14::TEX_GUI_BUTTON_1, LD14::TEX_GUI_BUTTON_2, LD14::TEX_GUI_BUTTON_3 );
  theApp.PrintNiceCentered( 320 - 60 + 60, 385, "I INFO" );

  theApp.RenderButton( 320 + 5 + 120 + 10, 380, 120, 40, LD14::TEX_GUI_BUTTON_1, LD14::TEX_GUI_BUTTON_2, LD14::TEX_GUI_BUTTON_3 );
  theApp.PrintNiceCentered( 320 + 5 + 120 + 10 + 60, 385, "ESC QUIT" );

  int   ButtonYOffset = 380;

}



void CGSMenu::UpdateFrame( const float fElapsedTime )
{

  m_Level.Update( fElapsedTime );

}



void CGSMenu::OnMouse( int X, int Y, int Buttons )
{

  int   ButtonYOffset = 380;

  if ( ( Buttons & 1 )
  &&   ( m_ButtonReleased ) )
  {
    m_ButtonReleased = false;

    if ( ( theApp.m_MouseX >= 320 - 5 - 120 - 10 - 120 )
    &&   ( theApp.m_MouseX < 320 - 5 - 120 - 10 - 120 + 120 )
    &&   ( theApp.m_MouseY >= ButtonYOffset )
    &&   ( theApp.m_MouseY < ButtonYOffset + 40 ) )
    {
      if ( theApp.m_MouseButtons & 1 )
      {
        OnChar( 'p' );
      }
    }
    if ( ( theApp.m_MouseX >= 320 - 60 )
    &&   ( theApp.m_MouseX < 320 - 60 + 120 )
    &&   ( theApp.m_MouseY >= ButtonYOffset )
    &&   ( theApp.m_MouseY < ButtonYOffset + 40 ) )
    {
      if ( theApp.m_MouseButtons & 1 )
      {
        OnChar( 'i' );
      }
    }
    if ( ( theApp.m_MouseX >= 320 + 5 + 120 + 10 )
    &&   ( theApp.m_MouseX < 320 + 5 + 120 + 10 + 120 )
    &&   ( theApp.m_MouseY >= ButtonYOffset )
    &&   ( theApp.m_MouseY < ButtonYOffset + 40 ) )
    {
      if ( theApp.m_MouseButtons & 1 )
      {
        OnChar( 27 );
      }
    }
  }

  if ( !( Buttons & 1 ) )
  {
    m_ButtonReleased = true;
  }

}



void CGSMenu::OnChar( int iChar )
{

  if ( iChar == 'p' )
  {
    theApp.NextState( new CGSGame() );
  }
  else if ( iChar == 'i' )
  {
    theApp.NextState( new CGSInstructions() );
  }
  else if ( iChar == 27 )
  {
    PostMessage( theApp.m_hWnd, WM_CLOSE, 0, 0 );
  }

}



void CGSMenu::OnKeyDown( int iChar )
{

}