#include <d3d8.h>

#include ".\GSInstructions.h"
#include ".\GSMenu.h"
#include ".\LD14.h"



CGSInstructions::CGSInstructions() :
  m_ButtonReleased( false ),
  m_CurPage( 0 )
{

  m_Level.Load( 254 );

}



CGSInstructions::~CGSInstructions()
{
}



void CGSInstructions::Display( IDirect3DDevice8* pDevice )
{

  m_Level.Render();

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

  theApp.PrintNiceCentered( 320, 20, "INSTRUCTIONS" );

  if ( m_CurPage == 0 )
  {
    theApp.PrintNice( 20,  70, "EVER SINCE I LEFT MY JOB I DREAMT OF BEING A" );
    theApp.PrintNice( 20, 110, "DOOM RUNNER AND WIN THE BIG ONE. I AND MY FAMILY" );
    theApp.PrintNice( 20, 150, "WOULD NEVER HAVE TO WORRY ABOUT MONEY AGAIN." );
    theApp.PrintNice( 20, 190, "  SO HERE I AM, IN THE SHOW. THERE ARE FOUR" );
    theApp.PrintNice( 20, 230, "COURSES TO SURVIVE. I'M ALLOWED TO KEEP EVERY" );
    theApp.PrintNice( 20, 270, "PRIZE I COLLECT ON IT. IF I ACTUALLY SURVIVE" );
    theApp.PrintNice( 20, 310, "I CAN SHARE THE PRIZE WITH MY FAMILY." );
  }
  else if ( m_CurPage == 1 )
  {
    theApp.PrintNice( 20,  70, "I HAVE TO KEEP ON RUNNING UNTIL I REACH THE FINISH" );
    theApp.PrintNice( 20, 110, "LINE. I CAN SLOW DOWN TO GRAB MORE PRIZES BUT" );
    theApp.PrintNice( 20, 150, "THAT MAKES THE ADVANCING SPIKE WALL BEHIND ME" );
    theApp.PrintNice( 20, 190, "COME CLOSER. I CAN SPEED UP FOR A SHORT TIME" );
    theApp.PrintNice( 20, 230, "BY PICKING UP BOOSTER PILLS." );
    theApp.PrintNice( 20, 270, "THE FLAGS ARE BONUS ITEMS. IF I MANAGE TO GET" );
    theApp.PrintNice( 20, 310, "ALL COLORED FLAGS AS DISPLAYED ON THE TOP I" );
  }
  else if ( m_CurPage == 2 )
  {
    theApp.PrintNice( 20,  70, "RECEIVE AN EXTRA BONUS." );
    theApp.PrintNice( 20, 110, "ANYTHING ELSE IS PRONE TO SLOW ME DOWN, EVENTUALLY" );
    theApp.PrintNice( 20, 150, "GETTING ME CRUSHED." );
    theApp.PrintNice( 20, 230, "MAY LUCK BE ON MY SIDE!" );
  }

  if ( m_CurPage < 2 )
  {
    theApp.RenderButton( 320 + 5, 380, 120, 40, LD14::TEX_GUI_BUTTON_1, LD14::TEX_GUI_BUTTON_2, LD14::TEX_GUI_BUTTON_3 );
    theApp.PrintNiceCentered( 320 + 5 + 60, 385, "NEXT" );
  }

  theApp.RenderButton( 320 + 5 + 120 + 10, 380, 120, 40, LD14::TEX_GUI_BUTTON_1, LD14::TEX_GUI_BUTTON_2, LD14::TEX_GUI_BUTTON_3 );
  theApp.PrintNiceCentered( 320 + 5 + 120 + 10 + 60, 385, "QUIT" );

}



void CGSInstructions::UpdateFrame( const float fElapsedTime )
{

}



void CGSInstructions::OnChar( int iChar )
{

  if ( iChar == 27 )
  {
    theApp.NextState( new CGSMenu() );
  }
  if ( ( iChar == ' ' )
  ||   ( iChar == 13 ) )
  {
    if ( m_CurPage < 2 )
    {
      ++m_CurPage;
    }
    else
    {
      theApp.NextState( new CGSMenu() );
    }
  }

}



void CGSInstructions::OnKeyDown( int iChar )
{

}



void CGSInstructions::OnMouse( int X, int Y, int Buttons )
{

  int   ButtonYOffset = 380;

  if ( ( Buttons & 1 )
  &&   ( m_ButtonReleased ) )
  {
    m_ButtonReleased = false;

    if ( ( theApp.m_MouseX >= 320 + 5 )
    &&   ( theApp.m_MouseX < 320 + 5 + 120 )
    &&   ( theApp.m_MouseY >= ButtonYOffset )
    &&   ( theApp.m_MouseY < ButtonYOffset + 40 ) )
    {
      if ( m_CurPage < 2 )
      {
        ++m_CurPage;
      }
    }
    if ( ( theApp.m_MouseX >= 320 + 5 + 120 + 10 )
    &&   ( theApp.m_MouseX < 320 + 5 + 120 + 10 + 120 )
    &&   ( theApp.m_MouseY >= ButtonYOffset )
    &&   ( theApp.m_MouseY < ButtonYOffset + 40 ) )
    {
      if ( theApp.m_MouseButtons & 1 )
      {
        OnChar( 27 );
      }
    }
  }

  if ( !( Buttons & 1 ) )
  {
    m_ButtonReleased = true;
  }

}



