#pragma once

#include <vector>

#include "gamestate.h"

#include "LD14.h"
#include "Level.h"
#include "GameObject.h"




class CGSGame : public CGameState
{

  public:

    struct PresentInfo
    {
      std::string       Prize;
      float             InfoPos;

      PresentInfo( const std::string& Prize = std::string() ) :
        Prize( Prize ),
        InfoPos( 0.0f )
      {
      }
    };

    std::list<PresentInfo>  m_PresentInfos;

    Level                   m_Level;

    bool                    m_ButtonReleased;

    int                     m_CurLevel;

    GameObject*             m_pPlayer;

    bool                    m_Done;

    D3DXVECTOR3             m_CameraPos;

    LD14::GameObjectType    m_NeededFlags[5];
    int                     m_NeededFlagsCollected;

    int                     m_MoneyCollected;

    int                     m_LastProgressCount;

    float                   m_StartCountDown;

    float                   m_DoomProgress;

    bool                    m_Caught;
    float                   m_CaughtTimer;

    float                   m_SlowedTimer;

    float                   m_BoostedTimer;


    CGSGame();
    virtual ~CGSGame();

    virtual void            Display( IDirect3DDevice8* pDevice );

    virtual void            UpdateFrame( const float fElapsedTime );

    virtual void            OnChar( int iChar );
    virtual void            OnKeyDown( int iChar );
    virtual void            OnMouse( int iX, int iY, int iButtons );
    virtual void            OnMouseWheel( int Delta );

    void                    PrepareLevel( int Level );

    void                    RetryLevel();

    bool                    OnCollision( GameObject& Obj1, GameObject& Obj2 );

    void                    RandomizeFlags();

};
