#include <d3d8.h>

#include ".\GSGame.h"
#include ".\GSMenu.h"
#include ".\GSDone.h"
#include ".\LD14.h"



CGSGame::CGSGame() :
  m_pPlayer( NULL ),
  m_CameraPos( 0.0f, 1.0f, 0.64f ),
  m_NeededFlagsCollected( 0 ),
  m_MoneyCollected( 0 ),
  m_Caught( false ),
  m_CaughtTimer( 0.0f ),
  m_SlowedTimer( 0.0f ),
  m_BoostedTimer( 0.0f )
{

  m_ButtonReleased    = false;
  m_Done              = false;

  m_Level.m_pGSGame = this;

  PrepareLevel( 1 );

}



CGSGame::~CGSGame()
{
}



void CGSGame::PrepareLevel( int Level )
{

  m_CurLevel          = Level;
  m_pPlayer           = NULL;
  m_Done              = false;

  if ( !m_Level.Load( m_CurLevel ) )
  {
    theApp.NextState( new CGSDone() );
    return;
  }

  m_pPlayer = new GameObject( LD14::GO_PLAYER_STAND );

  m_Level.Add( m_pPlayer );
  m_Level.m_pPlayer = m_pPlayer;

  RandomizeFlags();

  m_LastProgressCount = 0;

  m_StartCountDown  = 3.0f;
  m_DoomProgress    = -2.0f;

  m_Caught          = false;
  m_CaughtTimer     = 0.0f;
  m_SlowedTimer     = 0.0f;
  m_BoostedTimer    = 0.0f;

  m_CameraPos = D3DXVECTOR3( 0.0f, 1.0f, 0.64f );

}



void CGSGame::Display( IDirect3DDevice8* pDevice )
{

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHATESTENABLE, TRUE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

  D3DXMATRIX      MatWorld;  
  D3DXMATRIX      MatView;  
  D3DXMATRIX      MatProj;  

  D3DXMatrixIdentity( &MatWorld );
  D3DXMatrixLookAtLH( &MatView, 
                      &m_CameraPos,
                      &( m_CameraPos + D3DXVECTOR3( 0.0f, -5.0f, 0.0f ) ),
                      &D3DXVECTOR3( 0.0f, 0.0f, 1.0f ) );

  D3DXMatrixPerspectiveFovLH( &MatProj, D3DXToRadian( 90 ), 640.0f / 480.0f, 0.01f, 100.0f );

  pDevice->SetTransform( D3DTS_WORLD, &MatWorld );
  pDevice->SetTransform( D3DTS_VIEW, &MatView );
  pDevice->SetTransform( D3DTS_PROJECTION, &MatProj );

  m_Level.Render();

  if ( m_Caught )
  {
    theApp.m_pd3dDevice->SetTexture( 0, NULL );
    theApp.RenderQuad2d( 0, 0, 640, 480, 0x00ff4040 | ( ( (int)( m_CaughtTimer * 255 ) ) << 24 ) );
  }

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHATESTENABLE, TRUE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

  std::list<PresentInfo>::iterator    itPI( m_PresentInfos.begin() );
  while ( itPI != m_PresentInfos.end() )
  {
    PresentInfo&    PI( *itPI );

    theApp.PrintNiceCentered( 320, (int)( 280.0f * cosf( PI.InfoPos * 3.1415926f / 180.0f ) ), PI.Prize.c_str() );

    ++itPI;
  }

  // display flags
  for ( int i = 0; i < 5; ++i )
  {
    if ( m_NeededFlagsCollected > i )
    {
      theApp.m_pd3dDevice->SetTexture( 0, NULL );
      theApp.RenderQuad2d( 640 - 5 - 5 * 34 + i * 34 - 2, 5 - 2, 32, 32, 0x808080ff );
    }
    switch ( m_NeededFlags[i] )
    {
      case LD14::GO_FLAG_B:
        theApp.RenderTextureSection2d( 640 - 5 - 5 * 34 + i * 34, 5, theApp.m_TexSec[LD14::TEX_FLAG_B] );
        break;
      case LD14::GO_FLAG_R:
        theApp.RenderTextureSection2d( 640 - 5 - 5 * 34 + i * 34, 5, theApp.m_TexSec[LD14::TEX_FLAG_R] );
        break;
      case LD14::GO_FLAG_G:
        theApp.RenderTextureSection2d( 640 - 5 - 5 * 34 + i * 34, 5, theApp.m_TexSec[LD14::TEX_FLAG_G] );
        break;
      case LD14::GO_FLAG_Y:
        theApp.RenderTextureSection2d( 640 - 5 - 5 * 34 + i * 34, 5, theApp.m_TexSec[LD14::TEX_FLAG_Y] );
        break;
      case LD14::GO_FLAG_V:
        theApp.RenderTextureSection2d( 640 - 5 - 5 * 34 + i * 34, 5, theApp.m_TexSec[LD14::TEX_FLAG_V] );
        break;
    }
  }

  // display progress
  theApp.RenderTextureSection2d( 450, 444, theApp.m_TexSec[LD14::TEX_GUI_GOAL] );

  float   ShownOffset = m_Level.m_DisplayOffset;
  if ( ShownOffset > m_Level.m_Length )
  {
    ShownOffset = m_Level.m_Length;
  }
  theApp.RenderTextureSection2d( 10 + (int)( ShownOffset * 450 / m_Level.m_Length ), 444, theApp.m_TexSec[LD14::TEX_GUI_PLAYER] );

  theApp.RenderTextureSection2d( 10 + (int)( m_DoomProgress * 450 / m_Level.m_Length ), 444, theApp.m_TexSec[LD14::TEX_GUI_DOOM] );

  {
    char    Temp[200];

    sprintf( Temp, "Money $%d", m_MoneyCollected );
    theApp.PrintNice( 490, 444, Temp );
  }

  if ( m_Done )
  {
    std::string     WellDone = "WELL DONE!";

    theApp.PrintNiceCentered( 321, 200, WellDone.c_str(), 0xff000000 );
    theApp.PrintNiceCentered( 319, 200, WellDone.c_str(), 0xff000000 );
    theApp.PrintNiceCentered( 320, 199, WellDone.c_str(), 0xff000000 );
    theApp.PrintNiceCentered( 320, 201, WellDone.c_str(), 0xff000000 );

    theApp.PrintNiceCentered( 320, 200, WellDone.c_str() );
  }

  if ( m_StartCountDown > 0.0f )
  {
    std::string     GetReady = "GET READY";

    theApp.PrintNiceCentered( 321, 200, GetReady.c_str(), 0xff000000 );
    theApp.PrintNiceCentered( 319, 200, GetReady.c_str(), 0xff000000 );
    theApp.PrintNiceCentered( 320, 199, GetReady.c_str(), 0xff000000 );
    theApp.PrintNiceCentered( 320, 201, GetReady.c_str(), 0xff000000 );

    theApp.PrintNiceCentered( 320, 200, GetReady.c_str() );
  }

}



void CGSGame::UpdateFrame( const float fElapsedTime )
{

  if ( m_pPlayer == NULL )
  {
    return;
  }
  if ( m_StartCountDown > 0.0f )
  {
    m_StartCountDown -= fElapsedTime;
    if ( m_StartCountDown < 0.0f )
    {
      m_StartCountDown = 0.0f;
      m_pPlayer->m_Type = LD14::GO_PLAYER;
    }
    return;
  }

  std::list<PresentInfo>::iterator    itPI( m_PresentInfos.begin() );
  while ( itPI != m_PresentInfos.end() )
  {
    PresentInfo&    PI( *itPI );

    PI.InfoPos += 180.0f * fElapsedTime;
    if ( PI.InfoPos >= 180.0f )
    {
      itPI = m_PresentInfos.erase( itPI );
    }
    else
    {
      ++itPI;
    }
  }

  if ( m_Caught )
  {
    m_CaughtTimer += fElapsedTime;
    if ( m_CaughtTimer > 1.0f )
    {
      m_CaughtTimer = 1.0f;
      theApp.NextState( new CGSMenu() );
    }
  }
  if ( m_DoomProgress >= m_Level.m_DisplayOffset )
  {
    // caught
    m_Caught = true;
    return;
  }
  if ( m_Level.m_DisplayOffset >= m_Level.m_Length )
  {
    // Goal!
    m_Done = true;
    m_pPlayer->m_Type = LD14::GO_PLAYER_STAND;
  }

  if ( m_SlowedTimer > 0.0f )
  {
    m_SlowedTimer -= fElapsedTime;
    if ( m_SlowedTimer < 0.0f )
    {
      m_SlowedTimer = 0.0f;
    }
  }
  if ( m_BoostedTimer > 0.0f )
  {
    m_BoostedTimer -= fElapsedTime;
    if ( m_BoostedTimer < 0.0f )
    {
      m_BoostedTimer = 0.0f;
    }
  }

  if ( !m_Done )
  {
    if ( theApp.m_bKeyPressed[VK_LEFT] )
    {
      //m_CameraPos.x -= fElapsedTime;
      m_pPlayer->m_Pos.x -= 1.0f * fElapsedTime;
      if ( m_pPlayer->m_Pos.x < -1.05f )
      {
        m_pPlayer->m_Pos.x = -1.05f;
      }
    }
    if ( theApp.m_bKeyPressed[VK_RIGHT] )
    {
      m_pPlayer->m_Pos.x += 1.0f * fElapsedTime;
      if ( m_pPlayer->m_Pos.x > 1.05f )
      {
        m_pPlayer->m_Pos.x = 1.05f;
      }
    }
  }
  {
    float       MoveFactor = 1.0f;

    if ( m_SlowedTimer > 0.0f )
    {
      MoveFactor *= 0.5f;
    }
    if ( m_BoostedTimer > 0.0f )
    {
      MoveFactor *= 2.0f;
    }
    if ( m_Done )
    {
      MoveFactor = 0.0f;
    }

    float       Movement = -MoveFactor * fElapsedTime;

    if ( theApp.m_bKeyPressed[VK_DOWN] )
    {
      Movement *= 0.5f;
    }
    m_Level.CheckCollision( m_pPlayer, Movement );
    m_CameraPos.y = m_pPlayer->m_Pos.y + 1.0f;
    m_Level.m_DisplayOffset = -m_pPlayer->m_Pos.y;

    int   ProgressPos = (int)m_Level.m_DisplayOffset;
    if ( ProgressPos > (int)m_Level.m_Length )
    {
      ProgressPos = (int)m_Level.m_Length;
    }
    if ( ProgressPos > m_LastProgressCount )
    {
      // increase money while running
      m_MoneyCollected += ProgressPos - m_LastProgressCount;
      m_LastProgressCount = ProgressPos;
    }
  }
  if ( !m_Done )
  {
    m_DoomProgress += 1.0f * fElapsedTime;
  }
  /*
  if ( theApp.m_bKeyPressed[VK_DOWN] )
  {
    //m_CameraPos.y += fElapsedTime;
    m_Level.CheckCollision( m_pPlayer, 2.0f * fElapsedTime );
    //m_Level.UpdateObjectPos( m_pPlayer, 2.0f * fElapsedTime );

    m_CameraPos.y = m_pPlayer->m_Pos.y + 1.0f;

    m_Level.m_DisplayOffset = -m_pPlayer->m_Pos.y;
  }
  if ( theApp.m_bKeyPressed[VK_PRIOR] )
  {
    m_CameraPos.z -= fElapsedTime;
  }
  if ( theApp.m_bKeyPressed[VK_NEXT] )
  {
    m_CameraPos.z += fElapsedTime;
  }
  */
  if ( m_StartCountDown == 0.0f )
  {
    m_Level.Update( fElapsedTime );
    m_Level.PlayRequestedSounds();
  }

}



void CGSGame::OnChar( int iChar )
{

  if ( iChar == 27 )
  {
    theApp.NextState( new CGSMenu() );
  }
  else if ( iChar == 'n' )
  {
    m_CurLevel++;
    PrepareLevel( m_CurLevel );
    m_Done = false;
  }
  else if ( iChar == ' ' )
  {
    if ( m_StartCountDown > 0.0f )
    {
      m_StartCountDown = 0.0f;
      m_pPlayer->m_Type = LD14::GO_PLAYER;
    }
    else if ( m_Done )
    {
      m_CurLevel++;
      PrepareLevel( m_CurLevel );
      m_Done = false;
    }
    else
    {
      // Jump
      if ( !( m_pPlayer->m_Value2 & 1 ) )
      {
        m_pPlayer->m_Value2 |= 1;
        m_pPlayer->m_ValueF1 = 0.0f;
        m_Level.m_SoundRequests.insert( LD14::SOUND_JUMP );
      }
    }
  }

}



void CGSGame::OnKeyDown( int iChar )
{

  if ( iChar == VK_DOWN )
  {
  }

}



void CGSGame::RetryLevel()
{

  // Back to build up mode
  m_Done        = false;
  m_Level.Load( m_CurLevel );

}



void CGSGame::OnMouse( int iX, int iY, int iButtons )
{

  if ( ( iButtons & 1 )
  &&   ( m_ButtonReleased ) )
  {
    m_ButtonReleased = false;
  }

  if ( !( iButtons & 1 ) )
  {
    m_ButtonReleased = true;
  }

}




void CGSGame::OnMouseWheel( int Delta )
{

}



bool CGSGame::OnCollision( GameObject& Obj1, GameObject& Obj2 )
{

  switch ( Obj1.m_Type )
  {
    case LD14::GO_PLAYER:
      if ( ( Obj2.m_Type == LD14::GO_FLAG_B )
      ||   ( Obj2.m_Type == LD14::GO_FLAG_R )
      ||   ( Obj2.m_Type == LD14::GO_FLAG_Y )
      ||   ( Obj2.m_Type == LD14::GO_FLAG_G )
      ||   ( Obj2.m_Type == LD14::GO_FLAG_V ) )
      {
        // collect flag
        m_Level.m_SoundRequests.insert( LD14::SOUND_FLAG );
        Obj2.m_RemoveMe = true;

        m_MoneyCollected += 30;

        if ( Obj2.m_Type == m_NeededFlags[m_NeededFlagsCollected] )
        {
          ++m_NeededFlagsCollected;
          if ( m_NeededFlagsCollected == 5 )
          {
            m_MoneyCollected += 150;
            m_Level.m_SoundRequests.insert( LD14::SOUND_FLAG_BONUS );
            RandomizeFlags();
          }
        }
      }
      else if ( Obj2.m_Type == LD14::GO_NOTE )
      {
        m_Level.m_SoundRequests.insert( LD14::SOUND_GET_ITEM );
        Obj2.m_RemoveMe = true;
        m_MoneyCollected += 10;
      }
      else if ( Obj2.m_Type == LD14::GO_SPEEDUP )
      {
        m_Level.m_SoundRequests.insert( LD14::SOUND_GET_ITEM );
        Obj2.m_RemoveMe = true;
        m_MoneyCollected += 50;
        m_BoostedTimer = 0.5f;
      }
      else if ( Obj2.m_Type == LD14::GO_PRESENT )
      {
        m_Level.m_SoundRequests.insert( LD14::SOUND_GET_ITEM );
        Obj2.m_RemoveMe = true;

        switch ( rand() % 3 )
        {
          case 0:
            m_PresentInfos.push_back( PresentInfo( "Family Six Slot Toaster Deluxe" ) );
            break;
          case 1:
            m_PresentInfos.push_back( PresentInfo( "Orange Juice-O-Matic Grande" ) );
            break;
          case 2:
            m_PresentInfos.push_back( PresentInfo( "Food Stamp Catalog Weekly Edition" ) );
            break;
        }
        m_MoneyCollected += 250;
      }
      else if ( Obj2.m_Type == LD14::GO_BOARDS )
      {
        m_Level.m_SoundRequests.insert( LD14::SOUND_BREAK_BOARDS );
        Obj2.m_RemoveMe = true;
      }
      else if ( ( Obj2.m_Type == LD14::GO_WALL )
      ||        ( Obj2.m_Type == LD14::GO_FENCE )
      ||        ( Obj2.m_Type == LD14::GO_POLE ) )
      {
        // blocking!
        return true;
      }
      else if ( ( Obj2.m_Type == LD14::GO_SPIKE )
      ||        ( Obj2.m_Type == LD14::GO_SPIKE_BALL ) )
      {
        m_SlowedTimer = 0.5f;

        m_Level.m_SoundRequests.insert( LD14::SOUND_HURT );
      }
      break;
  }
  return false;

}



void CGSGame::RandomizeFlags()
{

  std::set<LD14::GameObjectType>    AllFlags;

  AllFlags.insert( LD14::GO_FLAG_B );
  AllFlags.insert( LD14::GO_FLAG_R );
  AllFlags.insert( LD14::GO_FLAG_G );
  AllFlags.insert( LD14::GO_FLAG_Y );
  AllFlags.insert( LD14::GO_FLAG_V );

  m_NeededFlagsCollected = 0;

  for ( int i = 0; i < 5; ++i )
  {
    int   Random = rand() % (int)AllFlags.size();

    std::set<LD14::GameObjectType>::iterator    it( AllFlags.begin() );
    std::advance( it, Random );

    m_NeededFlags[i] = *it;

    AllFlags.erase( it );
  }

}