#include <d3d8.h>

#include ".\GSDone.h"
#include ".\GSMenu.h"
#include ".\LD14.h"



CGSDone::CGSDone()
{

  m_ButtonReleased = false;
  m_Level.Load( 254 );

}



CGSDone::~CGSDone()
{
}



void CGSDone::Display( IDirect3DDevice8* pDevice )
{

  m_Level.Render();

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHATESTENABLE, TRUE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

  theApp.PrintNiceCentered( 320, 120, "WELL DONE!" );

  theApp.PrintNiceCentered( 320, 160, "Our mysterious candidate" );
  theApp.PrintNiceCentered( 320, 190, "managed to survive and win" );
  theApp.PrintNiceCentered( 320, 220, "a trip to Solitary Island" );
  theApp.PrintNiceCentered( 320, 250, "for him and his whole family!" );
  theApp.PrintNiceCentered( 320, 280, "Plus lots of goods from our" );
  theApp.PrintNiceCentered( 320, 310, "trusty sponsors!" );

}



void CGSDone::UpdateFrame( const float fElapsedTime )
{

  m_Level.Update( fElapsedTime );

}



void CGSDone::OnChar( int iChar )
{

  if ( ( iChar == 27 )
  ||   ( iChar == ' ' )
  ||   ( iChar == 13 ) )
  {
    theApp.NextState( new CGSMenu() );
  }

}



void CGSDone::OnKeyDown( int iChar )
{

}



void CGSDone::OnMouse( int X, int Y, int Buttons )
{

  if ( Buttons & 1 )
  {
    if ( m_ButtonReleased )
    {
      OnChar( 27 );
    }
  }
  else
  {
    m_ButtonReleased = true;
  }

}