#pragma once

#include <GR/GRTypes.h>

#include <Interface/IAnimationManager.h>

#include <list>

#include "PacTypes.h"
#include "TiledMover.h"



class XRenderer;
class PlayState;

class Wild : public TiledMover
{

  public:

    int                       m_NumTilesToMove;
    int                       m_NewMoveDelay;



    Wild();


    virtual void              UpdateFixed( PlayState& State );

    virtual void              ProcessEvent( PlayState& State, const eUnitEvent& Event );

    virtual void              OnLoad( PlayState& State );

    void                      OnArrivedAtTile( PlayState& State );

    int                       DetermineMovementPoints( Pac::eDir Dir );

    void                      SetRandomPossibleDir( PlayState& State );

};


