#pragma once

#include <GR/GRTypes.h>

#include <Interface/IAnimationManager.h>

#include <list>

#include "PacTypes.h"
#include "Unit.h"



class XRenderer;
class Level;

class TiledMover : public Unit
{

  public:

    bool                      m_NotMoving;



    TiledMover();


    virtual void              Update( PlayState& State, const GR::f32 fElapsedTime );
    virtual void              UpdateFixed( PlayState& State );

    virtual void              ProcessEvent( PlayState& State, const eUnitEvent& Event );

    virtual void              OnArrivedAtTile( PlayState& State );
    void                      AutoDetectDirection( PlayState& State );

    void                      TurnAround();

    void                      SetTilePos( int X, int Y );

    bool                      Move( PlayState& State, const GR::tPoint& DeltaArg, bool bMovedByPlatform = false );

    virtual void              OnSpawned( PlayState& State );

};


