#include ".\Spawn.h"
#include ".\Level.h"
#include ".\GetEmGood.h"
#include "PlayState.h"
#include "Player.h"



Spawn::Spawn()
{
  m_Type      = Pac::UT_SPAWN;
  m_SpawnUnit = Pac::UT_GREEN_MASK;
  SetAnimation( "Spawn" );

  m_LifeTime = 1.0f;
  m_DisplayOffset.set( -( 48 - 16 ) / 2, -( 21 - 16 ) / 2 - 10 );
}



void Spawn::ProcessEvent( PlayState& State, const eUnitEvent& Event )
{
  Unit::ProcessEvent( State, Event );

  switch ( Event )
  {
    case Unit::ET_DIE:
      {
        Unit* pUnit = State.Level.SpawnUnit( m_Position.x, m_Position.y, m_SpawnUnit, m_PlayerIndex );

        if ( m_SpawnUnit == Pac::UT_PLAYER )
        {
          // set start values
          Player*   pPlayer = (Player*)pUnit;
          pPlayer->m_BulletPower  = State.Player[m_PlayerIndex].BulletPower;
          pPlayer->m_FireDelayMax = State.Player[m_PlayerIndex].FireDelay;
          pPlayer->m_MoveSpeed    = State.Player[m_PlayerIndex].MoveSpeed;

          State.Player[m_PlayerIndex].Spawning = false;
        }
      }
      break;
  }
}