#include ".\PlayerShot.h"
#include ".\Level.h"
#include ".\GetEmGood.h"
#include "PlayState.h"



PlayerShot::PlayerShot()
{
  m_Type = Pac::UT_PLAYER_SHOT;
  m_Color = "Red";
  SetImage( "PlayerShot.R" );

  m_MoveSpeed = 24;
}



void PlayerShot::UpdateFixed( PlayState& State )
{
  if ( m_MoveDir == Pac::DIR_NONE )
  {
    m_RemoveMe = true;
  }
  TiledMover::UpdateFixed( State );
}



void PlayerShot::ProcessEvent( PlayState& State, const eUnitEvent& Event )
{
  TiledMover::ProcessEvent( State, Event );
  switch ( Event )
  {
    case ET_BLOCKED_UP:
    case ET_BLOCKED_DOWN:
    case ET_BLOCKED_LEFT:
    case ET_BLOCKED_RIGHT:
      m_RemoveMe = true;
      break;
    case ET_FALL_START:
      break;
    case ET_FALL_END:
      break;
    case ET_ENTER_PLATFORM:
      break;
    case ET_LEAVE_PLATFORM:
      break;
    case ET_DIE:
      break;
  }
}



void PlayerShot::OnArrivedAtTile( PlayState& State )
{
  TiledMover::OnArrivedAtTile( State );

  if ( State.Level.m_Field.Field( m_TilePos.x, m_TilePos.y ) == Pac::FT_CATERPILLAR_BODY )
  {
    State.Level.m_Field.SetField( m_TilePos.x, m_TilePos.y, Pac::FT_EMPTY );
    m_RemoveMe = true;
  }
}



void PlayerShot::OnLoad( PlayState& State )
{
  m_StartPosition = m_Position;
}



