#pragma once

#include <GR/GRTypes.h>

#include <Interface/IAnimationManager.h>

#include <list>

#include "PacTypes.h"
#include "Unit.h"
#include "TiledMover.h"



class XRenderer;
class PlayState;

class Player : public TiledMover
{

  public:

    Pac::eDir                 m_ShootDir;
    bool                      m_Moving;

    int                       m_FireDelay;
    int                       m_FireDelayMax;
    int                       m_BulletPower;
    int                       m_SlowDown;



    Player();


    virtual void              Update( PlayState& State, const GR::f32 fElapsedTime );
    virtual void              UpdateFixed( PlayState& State );

    virtual void              ProcessEvent( PlayState& State, const eUnitEvent& Event );

    virtual void              OnLoad( PlayState& State );

    virtual void              OnArrivedAtTile( PlayState& State );

    void                      FireShot( PlayState& State );

    void                      SetAnim();

    void                      CheckControls( PlayState& State );

};


