#pragma once

#include "Level.h"


struct tPlayerState
{
  int         PlayerIndex;
  int         MoveSpeed;
  int         BulletPower;
  int         FireDelay;
  int         DeathDelay;
  int         Bonus;
  bool        Spawning;



  tPlayerState() :
    PlayerIndex( 0 ),
    MoveSpeed( 8 ),
    BulletPower( 1 ),
    FireDelay( 15 ),
    DeathDelay( 0 ),
    Bonus( 0 ),
    Spawning( false)
  {
  }
};



class PlayState
{
  public:

    Pac::GameMode::Value      GameMode;

    Level                     Level;
    
    tPlayerState              Player[2];

    int                       ExtraState[8];

    int                       Bonus;
    int                       BonusTickDelay;

    int                       NumEnemiesSpawned;
    int                       PunishEnemiesSpawned;
    int                       TicksSinceLastDot;

    bool                      LevelIsCompleted;

    int                       LevelNumber;
    int                       Score;
    int                       Lives;

    std::list<Pac::eUnitTypes>    SpawnList;

    int                       LevelEndDelay;
    bool                      CaterpillarSpawned;

    std::string               Hint;



    PlayState();

    bool                      IsLevelCompleted();
    bool                      IsGameOver();

    int                       NumPlayers();

    void                      PrepareLevel();

    void                      UpdateFixed();

    void                      SpawnPlayer( int PlayerIndex );

};

