#ifndef PAC_TYPES_H
#define PAC_TYPES_H



class Unit;

namespace Pac
{
  namespace GameMode
  {
    enum Value
    {
      SINGLE_PLAYER,
      COOP
    };
  };

  namespace ControlKey
  {
    enum Value
    {
      PLAYER_1_LEFT = 0,
      PLAYER_1_RIGHT,
      PLAYER_1_UP,
      PLAYER_1_DOWN,
      PLAYER_1_ACTION,
      PLAYER_2_LEFT,
      PLAYER_2_RIGHT,
      PLAYER_2_UP,
      PLAYER_2_DOWN,
      PLAYER_2_ACTION,

      LEFT = 0,
      RIGHT,
      UP,
      DOWN,
      ACTION,

      NUM_ENTRIES
    };
  };

  enum eFeldTypes
  {
    FT_EMPTY = 0,
    FT_DOT,
    FT_FIRST_EXTRA,
    FT_EXTRA_BULLET_POWER = FT_FIRST_EXTRA,
    FT_EXTRA_LIFE,
    FT_EXTRA_FIRE_DELAY,
    FT_EXTRA_SHIELD,
    FT_EXTRA_SLOW_DOWN,
    FT_EXTRA_SPEED_UP,
    FT_EXTRA_SUPER_KILL,
    FT_EXTRA_TIME,
    FT_LAST_EXTRA = FT_EXTRA_TIME,
    FT_KEY,
    FT_LOCK,
    FT_CATERPILLAR_BODY,
    FT_WALL_1,
    FT_WALL_16 = FT_WALL_1 + 15,

    FT_LAST_ENTRY,

    FT_FORCE_DWORD = 0xffffffff,
  };

  enum eUnitTypes
  {
    UT_INVALID = -1,
    UT_PLAYER = 0,
    UT_GREEN_MASK,
    UT_PLAYER_SHOT,
    UT_EXPLOSION,
    UT_SPAWN,
    UT_RED_MASK,
    UT_BOMB,
    UT_CATERPILLAR,
    UT_WILD,
    UT_BAT,

    UT_LAST_ENTRY
  };

  enum eDir
  {
    DIR_NONE = 0,
    DIR_N,
    DIR_S,
    DIR_W,
    DIR_E
  };

  namespace Constants
  {
    enum eValue
    {
      NUM_MAX_PLAYERS = 2
    };
  }


  struct tGameEvent
  {
    enum eEventType
    {
      GE_INVALID,
      GE_CHANGE_SCORE,
      GE_LEVEL_COMPLETED,
      GE_PLAYER_DIED,
      GE_ITEM_COLLECTED,
      GE_UNIT_DELETED
    };

    eEventType      m_Type;
    GR::i32         m_Param[2];
    GR::String      m_TextParam;
    Unit*           pUnit;

    tGameEvent( const eEventType Type, Unit* pUnit ) :
      m_Type( Type ),
      pUnit( pUnit )
    {
      m_Param[0] = 0;
      m_Param[1] = 0;
    }

    tGameEvent( const eEventType Type = GE_INVALID, const GR::i32 iParam1 = 0, const GR::i32 iParam2 = 0 ) :
      m_Type( Type ),
      pUnit( NULL )
    {
      m_Param[0] = iParam1;
      m_Param[1] = iParam2;
    }

    tGameEvent( const eEventType Type, const GR::String& strParam, const GR::i32 iParam1 = 0, const GR::i32 iParam2 = 0 ) :
      m_Type( Type ),
      m_TextParam( strParam ),
      pUnit( NULL )
    {
      m_Param[0] = iParam1;
      m_Param[1] = iParam2;
    }

  };

};


#endif // PAC_TYPES_H