#ifndef GetEmGood_H_INCLUDED
#define GetEmGood_H_INCLUDED

#include <Xtreme/XRenderer.h>
#include <Xtreme/XFont.h>
#include <Xtreme/XTexture.h>
#include <Xtreme/XVertexBuffer.h>

#include <windows.h>

#include <vector>
#include <list>

#include <GR/GameState/GUIGameState.h>

#include <Controls/Xtreme/GUIComponentDisplayer.h>

#include <Interface/IEventListener.h>

#include <MasterFrame/XFrameApp.h>

#include "resource.h"

#include "PacTypes.h"



class GetEmGood : public CXFrameApp
{
  public:

    std::vector<XTextureSection>      m_Sections;

    std::map<char, XTextureSection>   m_Font;

    std::string         m_ActiveSong;
    std::string         m_NextSong;
    bool                m_MusicFadeOut;
    bool                m_MusicFadeIn;

    GR::f32             m_TempVolume;

    GR::u32             m_BestScore;
    GR::u32             m_BestScore2P;
    GR::u32             m_LastScore;
    GR::u32             m_LastScore2P;

    Pac::GameMode::Value  m_GameMode;



    GR::u32             m_BoundKeys[Pac::Constants::NUM_MAX_PLAYERS][Pac::ControlKey::NUM_ENTRIES];


    GetEmGood();
    virtual ~GetEmGood();


    bool                ProcessEvent( const GUI::OutputEvent& Event );


    // MasterFrame-spezifisch
    virtual bool        InitInstance();
    virtual void        ExitInstance();
    virtual void        UpdatePerDisplayFrame( const float fElapsedTime );
    virtual void        UpdateFixedLogic();

    virtual bool        ProcessEvent( const GR::Gamebase::tXFrameEvent& Event );

    virtual void        Configure( Xtreme::EnvironmentConfig& Config );

    void                RenderTextCentered( XRenderer& Renderer, int Y, const std::string& Text, GR::u32 Color = 0xffffffff );
    void                RenderText( XRenderer& Renderer, int X, int Y, const std::string& Text, GR::u32 Color = 0xffffffff );

    void                PlaySong( const std::string& Song );

};


extern GetEmGood          theApp;



#endif // GetEmGood_H_INCLUDED
