#pragma once

#include <GR/GRTypes.h>

#include "PacTypes.h"



class PlayState;

namespace GameLogic
{
  bool CanUnitPickKey( Pac::eUnitTypes UnitType );
  bool IsEnemy( Pac::eUnitTypes UnitType );

  void KillEnemy( PlayState& State, int PlayerIndex, Unit& Unit );
  void KillPlayer( PlayState& State, Unit* pUnit );

  void ExplodeBomb( PlayState& State, const GR::tPoint& TilePos );

  GR::u32 UnitsCollide( PlayState& State, Unit* pUnit1, Unit* pUnit2 );

  void GenerateExtra( PlayState& State, const GR::tPoint& TilePos );
  void ExtraPickedUp( PlayState& State, const GR::tPoint& TilePos, int PlayerIndex );

  void ActivateExtra( PlayState& State, Pac::eFeldTypes PickedExtra, int PlayerIndex );

  void DecreaseNumberOfDots( PlayState& State );

  void DropKey( PlayState& State, const GR::tPoint& TilePos );

  void LevelCompleted( PlayState& State );
}


