#ifndef GSMENU_H
#define GSMENU_H


#include <Xtreme/XRenderer.h>

#include <GR\GameState\GUIGameState.h>

#include <Controls\OutputEvent.h>

#include <Interface/IAnimationManager.h>

#include "FallingMenu.h"
#include "PacTypes.h"



class CGSMenu : public GUIGameState<XRenderer>, public EventListener<GUI::OutputEvent>
{

  public:

    DECLARE_CLONEABLE( CGSMenu, "GSMENU" )


    FallingMenu             m_Menu;

    int                     m_DisplayPage;
    int                     m_DisplayRow;
    int                     m_DisplayDelay;

    tAnimationPos           m_Anim[5];



    virtual void            Init();
    virtual void            Exit();


    virtual void            UpdatePerDisplayFrame( const GR::f32 ElapsedTime );
    virtual void            Display( XRenderer& Viewer );
    virtual void            Update();

    virtual bool            ProcessEvent( const GUI::OutputEvent& Event );

    void                    OnMenuHandler( FallingMenu::MenuEntryAction Action, const FallingMenu::tMenuEntry& Entry );

    void                    StartGame();

};

#endif // GSMENU
