#include <Misc/CloneFactory.h>

#include "GSMenu.h"
#include "GetEmGood.h"




IMPLEMENT_CLONEABLE( CGSMenu, "GSMenu" )



void CGSMenu::Init()
{
  m_DisplayDelay  = 0;
  m_DisplayPage   = 0;
  m_DisplayRow    = 0;

  m_Menu.Add( 16 );
  m_Menu.Add( 19, (int)( 20 + theApp.m_GameMode ) );
  m_Menu.SetItemLeftRightActive( 19, true );
  m_Menu.Add( 17 );
  m_Menu.Add( 18 );
  m_Menu.SetMenuHandler( fastdelegate::MakeDelegate( this, &CGSMenu::OnMenuHandler ) );

  theApp.PlaySong( "Get_em_DX_title" );

  m_Anim[0] = theApp.AnimationPos( "GreenMask.Move" );
  m_Anim[1] = theApp.AnimationPos( "RedMask.Move" );
  m_Anim[2] = theApp.AnimationPos( "Caterpillar" );
  m_Anim[3] = theApp.AnimationPos( "Bomb.Move" );
  m_Anim[4] = theApp.AnimationPos( "Wild.Move" );
}



void CGSMenu::Exit()
{
  // TODO - GUIScreen entfernen
}



void CGSMenu::OnMenuHandler( FallingMenu::MenuEntryAction Action, const FallingMenu::tMenuEntry& Entry )
{
  switch ( Action )
  {
    case FallingMenu::MEA_RIGHT_PRESSED:
      switch ( Entry.TextID )
      {
        case 19:
          {
            if ( theApp.m_GameMode == Pac::GameMode::SINGLE_PLAYER )
            {
              theApp.m_GameMode = Pac::GameMode::COOP;
            }
            else
            {
              theApp.m_GameMode = Pac::GameMode::SINGLE_PLAYER;
            }
            m_Menu.SetItemSubText( 19, 20 + ( theApp.m_GameMode ) );
          }
          break;
      }
      break;
    case FallingMenu::MEA_LEFT_PRESSED:
      switch ( Entry.TextID )
      {
        case 19:
          {
            if ( theApp.m_GameMode == Pac::GameMode::SINGLE_PLAYER )
            {
              theApp.m_GameMode = Pac::GameMode::COOP;
            }
            else
            {
              theApp.m_GameMode = Pac::GameMode::SINGLE_PLAYER;
            }
            m_Menu.SetItemSubText( 19, 20 + ( theApp.m_GameMode ) );
          }
          break;
      }
      break;
  }
}



void CGSMenu::StartGame()
{
  GR::Strings::ParameterList    params;

  params.SetParam( "GameMode", theApp.m_GameMode );
  ChangeState( "GSGame", params );
}



void CGSMenu::UpdatePerDisplayFrame( const GR::f32 ElapsedTime )
{
  for ( int i = 0; i < 5; ++i )
  {
    theApp.m_AnimationManager.AdvanceAnimFrame( m_Anim[i], ElapsedTime * 1000.0f );
  }

  if ( theApp.InputClass()->ReleasedKeyPressed( Xtreme::KEY_ESCAPE ) )
  {
    GLOBAL_QUEUE.PostEvent( "App.ShutDown" );
  }
  if ( theApp.InputClass()->ReleasedKeyPressed( Xtreme::KEY_E ) )
  {
    ChangeState( "GSEdit" );
  }
  if ( theApp.InputClass()->ReleasedKeyPressed( Xtreme::KEY_O ) )
  {
    ChangeState( "GSOptions" );
  }
  if ( theApp.InputClass()->ReleasedKeyPressed( Xtreme::KEY_P ) )
  {
    StartGame();
  }
  m_Menu.Update( ElapsedTime );
  if ( m_Menu.Done() )
  {
    m_Menu.SetUndone();
    switch ( m_Menu.SelectedItem() )
    {
      case 16:
        StartGame();
        break;
      case 19:
        // change game mode
        if ( theApp.m_GameMode == Pac::GameMode::SINGLE_PLAYER )
        {
          theApp.m_GameMode = Pac::GameMode::COOP;
        }
        else
        {
          theApp.m_GameMode = Pac::GameMode::SINGLE_PLAYER;
        }
        m_Menu.SetItemSubText( 19, 20 + ( theApp.m_GameMode ) );
        break;
      case 17:
        ChangeState( "GSOptions" );
        break;
      case 18:
        GLOBAL_QUEUE.PostEvent( "App.ShutDown" );
        break;
    }
  }
}



void CGSMenu::Display( XRenderer& Renderer )
{
  Renderer.SetShader( XRenderer::ST_FLAT );
  Renderer.RenderTextureSection2d( ( Renderer.Width() - 2 * 288 ) / 2 + 20, 80, theApp.Section( "Title" ), 0xffffffff, 2 * 288, 2 * 43 );
  if ( theApp.m_GameMode == Pac::GameMode::SINGLE_PLAYER )
  {
    theApp.RenderText( Renderer, 0, 0, Misc::Format( "BEST SCORE %01:8%" ) << theApp.m_BestScore, 0xFFA9F3FF );
    theApp.RenderText( Renderer, 800 - ( 11 + 8 ) * 16, 0, Misc::Format( "LAST SCORE %01:8%" ) << theApp.m_LastScore, 0xFFA9F3FF );
  }
  else
  {
    theApp.RenderText( Renderer, 0, 0, Misc::Format( "BEST SCORE %01:8%" ) << theApp.m_BestScore2P, 0xFFA9F3FF );
    theApp.RenderText( Renderer, 800 - ( 11 + 8 ) * 16, 0, Misc::Format( "LAST SCORE %01:8%" ) << theApp.m_LastScore2P, 0xFFA9F3FF );
  }

  Renderer.SetShader( XRenderer::ST_ALPHA_TEST );
  switch ( m_DisplayPage )
  {
    case 0:
      theApp.RenderTextCentered( Renderer, 200, "WRITTEN BY GEORG ROTTENSTEINER 2018", 0xFFB19EFF );
      if ( m_DisplayRow >= 1 )
      {
        theApp.RenderTextCentered( Renderer, 260, "COLLECT ALL DOTS AND GRAB THE" );
      }
      if ( m_DisplayRow >= 2 )
      {
        theApp.RenderTextCentered( Renderer, 290, "KEY TO UNLOCK THE EXIT" );
      }
      if ( m_DisplayRow >= 3 )
      {
        theApp.RenderTextCentered( Renderer, 320, "THIS GAME IS BASED ON THE C64" );
      }
      if ( m_DisplayRow >= 4 )
      {
        theApp.RenderTextCentered( Renderer, 350, "RELEASE AND FORGET ME NOT" );
      }
      if ( m_DisplayRow >= 5 )
      {
        theApp.RenderTextCentered( Renderer, 380, "PRESS FIRE TO PLAY" );
      }
      break;
    case 1:
      theApp.RenderTextCentered( Renderer, 200, "GRAPHICS BY ILIJA MELENTIJEVIC", 0xFFB19EFF );
      if ( m_DisplayRow >= 1 )
      {
        theApp.RenderTextCentered( Renderer, 260, "GREEN TROLL                10 PTS" );
        Renderer.RenderTextureSection2d( 470, 246, theApp.AnimationFrame( m_Anim[0] ) );
      }
      if ( m_DisplayRow >= 2 )
      {
        theApp.RenderTextCentered( Renderer, 290, "RED TROLL                  50 PTS" );
        Renderer.RenderTextureSection2d( 470, 276, theApp.AnimationFrame( m_Anim[1] ) );
      }
      if ( m_DisplayRow >= 3 )
      {
        theApp.RenderTextCentered( Renderer, 320, "CATERPILLAR               100 PTS" );
        Renderer.RenderTextureSection2d( 470, 306, theApp.AnimationFrame( m_Anim[2] ) );
      }
      if ( m_DisplayRow >= 4 )
      {
        theApp.RenderTextCentered( Renderer, 350, "BOMBOR                    250 PTS" );
        Renderer.RenderTextureSection2d( 470, 336, theApp.AnimationFrame( m_Anim[3] ) );
      }
      if ( m_DisplayRow >= 5 )
      {
        theApp.RenderTextCentered( Renderer, 380, "SHAMAN                    500 PTS" );
        Renderer.RenderTextureSection2d( 470, 366, theApp.AnimationFrame( m_Anim[4] ) );
      }
      break;
    case 2:
      theApp.RenderTextCentered( Renderer, 200, "MUSIC BY SEAN CONNOLLY", 0xFFB19EFF );
      if ( m_DisplayRow >= 1 )
      {
        theApp.RenderTextCentered( Renderer, 260, "EXTRA TIME                  5 PTS" );
        Renderer.RenderTextureSection2d( 450, 260, theApp.Section( "Extra.Time" ) );
      }
      if ( m_DisplayRow >= 2 )
      {
        theApp.RenderTextCentered( Renderer, 290, "SHOT RATE UP               10 PTS" );
        Renderer.RenderTextureSection2d( 450, 290, theApp.Section( "Extra.FireDelay" ) );
      }
      if ( m_DisplayRow >= 3 )
      {
        theApp.RenderTextCentered( Renderer, 320, "SMART BOMB                 15 PTS" );
        Renderer.RenderTextureSection2d( 450, 320, theApp.Section( "Extra.SuperKill" ) );
      }
      if ( m_DisplayRow >= 4 )
      {
        theApp.RenderTextCentered( Renderer, 350, "INVINCIBILITY              20 PTS" );
        Renderer.RenderTextureSection2d( 450, 350, theApp.Section( "Extra.Shield" ) );
      }
      if ( m_DisplayRow >= 5 )
      {
        theApp.RenderTextCentered( Renderer, 380, "GRAB 9 OF A KIND FOR EFFECT" );
      }
      break;
    case 3:
      if ( m_DisplayRow >= 1 )
      {
        theApp.RenderTextCentered( Renderer, 260, "SLOWDOWN                   25 PTS" );
        Renderer.RenderTextureSection2d( 450, 260, theApp.Section( "Extra.SlowDown" ) );
      }
      if ( m_DisplayRow >= 2 )
      {
        theApp.RenderTextCentered( Renderer, 290, "SHOT POWER UP              30 PTS" );
        Renderer.RenderTextureSection2d( 450, 290, theApp.Section( "Extra.BulletPower" ) );
      }
      if ( m_DisplayRow >= 3 )
      {
        theApp.RenderTextCentered( Renderer, 320, "SPEEDUP                    40 PTS" );
        Renderer.RenderTextureSection2d( 450, 320, theApp.Section( "Extra.SpeedUp" ) );
      }
      if ( m_DisplayRow >= 4 )
      {
        theApp.RenderTextCentered( Renderer, 350, "EXTRA LIFE                 50 PTS" );
        Renderer.RenderTextureSection2d( 450, 350, theApp.Section( "Extra.ExtraLife" ) );
      }
      if ( m_DisplayRow >= 5 )
      {
        theApp.RenderTextCentered( Renderer, 380, "GRAB 9 OF A KIND FOR EFFECT" );
      }
      break;
  }

  m_Menu.Display( Renderer, 400, 500 );
}



void CGSMenu::Update()
{
  ++m_DisplayDelay;
  if ( m_DisplayDelay >= 80 )
  {
    m_DisplayDelay = 0;
    if ( m_DisplayRow == 5 )
    {
      m_DisplayRow = 0;
      m_DisplayPage = ( m_DisplayPage + 1 ) % 4;
    }
    else
    {
      ++m_DisplayRow;
    }
  }
}



bool CGSMenu::ProcessEvent( const GUI::OutputEvent& Event )
{
  switch ( Event.Type )
  {
    case OET_BUTTON_PUSHED:
      break;
  }
  return false;
}
