#ifndef GSGAMEOVER_H
#define GSGAMEOVER_H


#include <Xtreme/XRenderer.h>

#include <GR\GameState\GUIGameState.h>

#include <Controls\OutputEvent.h>

#include "FallingMenu.h"
#include "PacTypes.h"



class CGSGameOver : public GUIGameState<XRenderer>, public EventListener<GUI::OutputEvent>
{

  public:

    DECLARE_CLONEABLE( CGSGameOver, "GSGameOver" )


    int                     m_FinishDelay;


    virtual void            Init();
    virtual void            Exit();


    virtual void            UpdatePerDisplayFrame( const GR::f32 ElapsedTime );
    virtual void            Display( XRenderer& Viewer );
    virtual void            Update();

    virtual bool            ProcessEvent( const GUI::OutputEvent& Event );

};

#endif // GSGAMEOVER_H
