#include <Misc/CloneFactory.h>

#include "GSGameOver.h"
#include "GetEmGood.h"




IMPLEMENT_CLONEABLE( CGSGameOver, "GSGameOver" )



void CGSGameOver::Init()
{
  theApp.PlaySong( "" );
  m_FinishDelay = 0;
}



void CGSGameOver::Exit()
{
  // TODO - GUIScreen entfernen
}



void CGSGameOver::UpdatePerDisplayFrame( const GR::f32 ElapsedTime )
{
  if ( theApp.InputClass()->ReleasedKeyPressed( Xtreme::KEY_ESCAPE ) )
  {
    ChangeState( "GSMenu" );
  }
}



void CGSGameOver::Display( XRenderer& Renderer )
{
  std::string     text = Misc::Format( "FINAL SCORE  %01:8%" ) << m_paramInit.GetParamIP( "Score" );

  // TODO - flash?
  theApp.RenderTextCentered( Renderer, 290, text, 0xffffffff );
}



void CGSGameOver::Update()
{
  ++m_FinishDelay;
  if ( m_FinishDelay >= 200 )
  {
    ChangeState( "GSMenu" );
  }
}



bool CGSGameOver::ProcessEvent( const GUI::OutputEvent& Event )
{
  switch ( Event.Type )
  {
    case OET_BUTTON_PUSHED:
      break;
  }
  return false;
}
