#ifndef GSGame_H
#define GSGame_H


#include <Xtreme/XRenderer.h>

#include <GR\GameState\GUIGameState.h>

#include <Controls\OutputEvent.h>

#include "PlayState.h"



class CGSGame : public GUIGameState<XRenderer>, public EventListener<GUI::OutputEvent>
{

  public:

    DECLARE_CLONEABLE( CGSGame, "GSGame" )


    PlayState               m_PlayState;

    int                     m_LevelNo;



    virtual void            Init();
    virtual void            Exit();


    virtual void            UpdatePerDisplayFrame( const GR::f32 ElapsedTime );
    virtual void            Display( XRenderer& Viewer );
    virtual void            Update();

    virtual bool            ProcessEvent( const GUI::OutputEvent& Event );

    void                    OnGameEvent( const Pac::tGameEvent& Event );

    void                    SpawnPlayer( int PlayerIndex );

    virtual void            OnResume();

};

#endif // GSGame_H
