#ifndef GSEDIT_H
#define GSEDIT_H


#include <Xtreme/XRenderer.h>

#include <GR\GameState\GUIGameState.h>

#include <Controls\OutputEvent.h>

#include "Level.h"



class CGSEdit : public GUIGameState<XRenderer>, public EventListener<GUI::OutputEvent>
{

  public:

    DECLARE_CLONEABLE( CGSEdit, "GSEdit" )


    Level                   m_Level;

    int                     m_LevelNo;

    Pac::eFeldTypes         m_CurrentTile;



    virtual void            Init();
    virtual void            Exit();


    virtual void            UpdatePerDisplayFrame( const GR::f32 ElapsedTime );
    virtual void            Display( XRenderer& Viewer );
    virtual void            Update();

    virtual bool            ProcessEvent( const GUI::OutputEvent& Event );

};

#endif // GSEDIT_H
