#ifndef ROTATING_MENU
#define ROTATING_MENU



#include <string>
#include <vector>
#include <list>

#include <GR/GRTypes.h>

#include <Xtreme/XTextureSection.h>

#include <lang/fastdelegate.h>



class XRenderer;

class FallingMenu
{

  public:

    enum MenuEntryAction
    {
      MEA_NONE,
      MEA_SELECTED,
      MEA_LEFT_PRESSED,
      MEA_RIGHT_PRESSED
    };


    struct tMenuEntry
    {
      std::string           Text;
      std::string           SubText;
      int                   MenuItemValue;
      int                   MenuItemParam;
      GR::f32               ActiveState;
      bool                  LeftRightActive;
      int                   TextID;
      int                   SubTextID;



      tMenuEntry( const std::string& Text, const std::string& SubText = std::string(), int Value = -1, int Param = -1 ) :
        Text( Text ),
        SubText( SubText ),
        MenuItemValue( Value ),
        ActiveState( 0.5f ),
        MenuItemParam( Param ),
        LeftRightActive( false ),
        TextID( -1 ),
        SubTextID( -1 )
      {
      }
    };

    typedef std::vector<tMenuEntry>   tMenu;

    typedef fastdelegate::FastDelegate2<MenuEntryAction,const tMenuEntry&>  tMenuHandlerFunction;

    int                               m_ItemHeight;

    tMenuHandlerFunction              m_MenuHandler;



  private:

    tMenu                             m_Entries;

    GR::tPoint                        m_CenterPos;

    GR::tPoint                        m_FixedSize;

    size_t                            m_CurrentItem;
    size_t                            m_MouseOverItem;
    int                               m_ItemDelta;

    bool                              m_MouseButtonReleased;
    bool                              m_Done;



  public:

    GR::f32                           m_Angle;
    GR::f32                           m_ZPos;
    GR::f32                           m_Alpha;

    

    FallingMenu();


    void                              Display( XRenderer& Renderer, int CenterX = 400, int CenterY = 300 );
    void                              DisplayBackground( XRenderer& Renderer, 
                                         int X,
                                         int Y,
                                         int Width,
                                         int Height );


    void                              Update( const GR::f32 ElapsedTime );


    void                              Add( int Entry, int SubEntry = -1, int MenuParam = -1 );
    void                              Add( int Entry, const std::string& SubText, int MenuParam );

    void                              SetValues( const GR::tPoint& Center, const GR::tPoint& FixedSize = GR::tPoint() );

    void                              Move( int Delta );

    int                               SelectedItem() const;
    int                               SelectedItemParam() const;

    bool                              Done() const;
    void                              SetUndone();

    void                              SetItemText( int Item, int Value );
    void                              SetItemText( int Item, const std::string& Text );
    void                              SetItemSubText( int Item, int SubText );
    void                              SetItemSubText( int Item, const std::string& SubText );
    void                              SetItemLeftRightActive( int Item, bool Active = false );
    void                              UpdateItemText( int ID );

    int                               GetItemParamByID( int ID );

    int                               EntryCount() const;
    void                              Clear();

    int                               MaxTextWidth() const;
    int                               DisplayWidth() const;
    int                               DisplayHeight() const;

    void                              FillTags( std::string& Caption );

    void                              SetMenuHandler( tMenuHandlerFunction Handler );
    void                              ReloadTexts();


    void                              RenderTextureSection( XRenderer& Renderer, int X, int Y, XTextureSection& Section, GR::u32 Color = 0xffffffff, int AlternateW = -1, int AlternateH = -1 );
};



#endif // ROTATING_MENU