#pragma once

#include <GR/GRTypes.h>

#include <Interface/IAnimationManager.h>

#include <list>

#include "PacTypes.h"
#include "TiledMover.h"



class XRenderer;
class PlayState;

class Bomb : public TiledMover
{

  public:

    int                       m_NumTilesToMove;



    Bomb();


    virtual void              Display( const GR::tPoint& ptOffset, XRenderer& Renderer );
    virtual void              UpdateFixed( PlayState& State );

    virtual void              ProcessEvent( PlayState& State, const eUnitEvent& Event );

    virtual void              OnLoad( PlayState& State );

    void                      OnArrivedAtTile( PlayState& State );

    int                       DetermineMovementPoints( Pac::eDir Dir );

};


