#include ".\util.h"

DWORD Util::ColorFromFloat( float fRed, float fGreen, float fBlue )
{

  return 0xff000000 + ( (int)( fRed * 255.0f ) << 16 ) + ( (int)( fGreen * 255.0f ) << 8 ) + (int)( fBlue * 255.0f );

}



bool Util::PotentialWall( Light::eTextureSections tsTile )
{

  if ( ( tsTile == Light::TS_EMPTY )
  ||   ( tsTile == Light::TS_WALL_END_E )
  ||   ( tsTile == Light::TS_WALL_END_N )
  ||   ( tsTile == Light::TS_WALL_END_S )
  ||   ( tsTile == Light::TS_WALL_END_W )
  ||   ( tsTile == Light::TS_WALL_H )
  ||   ( tsTile == Light::TS_WALL_LO )
  ||   ( tsTile == Light::TS_WALL_LU )
  ||   ( tsTile == Light::TS_WALL_RO )
  ||   ( tsTile == Light::TS_WALL_RU )
  ||   ( tsTile == Light::TS_WALL_T_E )
  ||   ( tsTile == Light::TS_WALL_T_N )
  ||   ( tsTile == Light::TS_WALL_T_S )
  ||   ( tsTile == Light::TS_WALL_T_W )
  ||   ( tsTile == Light::TS_WALL_V )
  ||   ( tsTile == Light::TS_WALL_X ) )
  {
    return true;
  }

  return false;

}



bool Util::IsFloor( Light::eTextureSections tsTile )
{

  if ( ( tsTile == Light::TS_FLOOR )
  ||   ( tsTile == Light::TS_MARBLE )
  ||   ( tsTile == Light::TS_CHECKERBOARD ) )
  {
    return true;
  }
  return false;

}