#ifndef LIGHT_TYPES_H
#define LIGHT_TYPES_H

namespace Light
{

  enum eTextureSections
  {
    TS_EMPTY,
    TS_WALL_H,
    TS_WALL_V,
    TS_WALL_LO,
    TS_WALL_RO,
    TS_WALL_LU,
    TS_WALL_RU,
    TS_WALL_T_S,
    TS_WALL_T_E,
    TS_WALL_T_N,
    TS_WALL_T_W,
    TS_WALL_X,
    TS_WALL_END_E,
    TS_WALL_END_N,
    TS_WALL_END_W,
    TS_WALL_END_S,
    TS_FLOOR,

    TS_PLAYER_STAND,
    TS_PLAYER_WALK_1,
    TS_PLAYER_WALK_2,

    TS_LAMP,

    TS_GUARD_STAND,
    TS_GUARD_WALK_1,
    TS_GUARD_WALK_2,

    TS_DOOR_H,
    TS_DOOR_V,

    TS_KEYCARD,
    TS_TOILET,
    TS_DESK,
    TS_CUPBOARD,

    TS_SILENT,
    TS_HUNTER,
    TS_FLOWER_BOX,

    TS_MARBLE,
    TS_CHECKERBOARD,

    TS_CHAIR,
    TS_COUCH,
    TS_WATER_FOUNTAIN,
    TS_SMALL_TABLE,

    TS_WALL_LIGHT,

    TS_MAX_SECTIONS,
  };

  enum eGameObjectType
  {
    OT_INVALID,
    OT_PLAYER,
    OT_LAMP,
    OT_GUARD,
    OT_KEYCARD,
    OT_TOILET,
    OT_DESK,
    OT_CUPBOARD,
    OT_FLOWERBOX,
    OT_CHAIR,
    OT_COUCH,
    OT_WATER_FOUNTAIN,
    OT_WALL_LIGHT,
    OT_SMALL_TABLE,

    OT_MAX_OBJECTS,
  };

  enum eGameConstants
  {
  };

  enum eLightSource
  {
    LS_PLAYER_LIGHT   = 0x00000001,
    LS_GUARD          = 0x00000002,
    LS_LAMP           = 0x00000004,
    LS_PLAYER_OBJECT  = 0x00000008, // the players spot
  };

  enum eCaughtReason
  {
    CR_INVALID,
    CR_SEEN,
    CR_SEEN_LIGHT,
    CR_HEARD,
  };


};


#endif // LIGHT_TYPES_H