#pragma once

#include <windows.h>

#include <d3d8.h>
#include <d3dx8.h>
#include <dsound.h>

#include <map>

#include "TextureSection.h"
#include "LightTypes.h"
#include "GameState.h"
#include "Level.h"



class CLightAndDark
{

  public:

    typedef std::map<char,tTextureSection>    tMapLetters;


    IDirect3D8*           m_pd3d;

    IDirect3DDevice8*     m_pd3dDevice;

    IDirect3DTexture8*    m_pTexture;
    IDirect3DTexture8*    m_pTextureObjects;
    IDirect3DTexture8*    m_pTextureSilent;
    IDirect3DTexture8*    m_pTextureHunter;
    IDirect3DTexture8*    m_pTextureFont;

    ID3DXFont*            m_pFont;

    IDirectSound*         m_pDirectSound;

    IDirectSoundBuffer*   m_pSoundClick;
    IDirectSoundBuffer*   m_pSoundStep;
    IDirectSoundBuffer*   m_pSoundSwipe;
    IDirectSoundBuffer*   m_pSoundCaught;
    IDirectSoundBuffer*   m_pSoundPickup;
    IDirectSoundBuffer*   m_pSoundCrash;

    D3DPRESENT_PARAMETERS m_d3dPP;

    tMapLetters           m_mapLetters;

    HWND                  m_hWnd;

    HICON                 m_hIcon;

    DWORD                 m_dwLastTicks;

    tTextureSection       m_TexSec[Light::TS_MAX_SECTIONS];

    CGameState*           m_pCurrentGameState;

    CGameState*           m_pNextState;

    CLevel                m_IntroLevel;

    bool                  m_bKeyPressed[256];
    bool                  m_bKeyReleased[256];

    float                 m_fWavyTextTimeCount;


    CLightAndDark();
    ~CLightAndDark();


    void                  RenderTextureSection( int iX, int iY, 
                                                const tTextureSection& TexSection, 
                                                DWORD dwColor = 0xffffffff, 
                                                DWORD dwColor2 = 0, 
                                                DWORD dwColor3 = 0, 
                                                DWORD dwColor4 = 0, 
                                                int iWidth = -1, int iHeight = -1, 
                                                DWORD dwAlternativeFlags = 0 );
    void                  RenderTextureSectionRotated( int iX, int iY, 
                                                       const tTextureSection& TexSection, 
                                                       float fAngle,
                                                       DWORD dwColor = 0xffffffff, 
                                                       DWORD dwColor2 = 0, 
                                                       DWORD dwColor3 = 0, 
                                                       DWORD dwColor4 = 0, 
                                                       int iWidth = -1, int iHeight = -1, 
                                                       DWORD dwAlternativeFlags = 0 );
    void                  RenderQuad( int iX, int iY, int iWidth, int iHeight,
                                      float fTU1, float fTV1,
                                      float fTU2, float fTV2,
                                      float fTU3, float fTV3,
                                      float fTU4, float fTV4,
                                      DWORD dwColor,
                                      DWORD dwColor2 = 0, 
                                      DWORD dwColor3 = 0, 
                                      DWORD dwColor4 = 0 );
    void                  RenderQuadRotated( int iX, int iY, int iWidth, int iHeight,
                                             float fTU1, float fTV1,
                                             float fTU2, float fTV2,
                                             float fTU3, float fTV3,
                                             float fTU4, float fTV4,
                                             float fAngle,
                                             DWORD dwColor,
                                             DWORD dwColor2 = 0, 
                                             DWORD dwColor3 = 0, 
                                             DWORD dwColor4 = 0 );

    void                  Print( int iX, int iY, const char* szText, DWORD dwColor = 0xffffffff );
    void                  PrintNice( int iX, int iY, const char* szText, DWORD dwColor = 0xffffffff );
    void                  PrintNiceCentered( int iX, int iY, const char* szText, DWORD dwColor = 0xffffffff, bool bWavy = false );
    void                  PrintNiceCenteredWavy( int iX, int iY, const char* szText, DWORD dwColor = 0xffffffff );

    IDirect3DTexture8*    LoadTexture( const char* szFileName, DWORD dwColorKey = 0 );
    IDirectSoundBuffer*   LoadWave( const char* szFileName );

    static LRESULT        StaticWindowProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
    LRESULT               WindowProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );

    void                  RenderFrame();
    void                  UpdateFrame( const float fElapsedTime );

    void                  NextState( CGameState* pNewState );

    void                  Run();

    void                  LoadResources();
    void                  UnloadResources();
    void                  Load3dResources();
    void                  Unload3dResources();

};


extern CLightAndDark    theApp;

