#pragma once

#include <list>
#include <set>

#include <d3dx8.h>

#include "LightTypes.h"



class CGameObject;
class CPlayer;
struct IDirect3DDevice8;

class CLevel
{

  public:

    struct tTileInfo
    {
      DWORD       dwColor[4];
      float       fLightPower[4];
      bool        bCouldBeSeenByPlayer;
      DWORD       dwLightSources;

      tTileInfo()
      {
        dwColor[0] = 0xff202020;
        dwColor[1] = 0xff202020;
        dwColor[2] = 0xff202020;
        dwColor[3] = 0xff202020;
        fLightPower[0] = 0.0f;
        fLightPower[1] = 0.0f;
        fLightPower[2] = 0.0f;
        fLightPower[3] = 0.0f;
        bCouldBeSeenByPlayer = false;
        dwLightSources = 0;
      }

      void Darken()
      {
        for ( int i = 0; i < 4; ++i )
        {
          fLightPower[i] = 0.0f;
          dwColor[i] = 0xff000000;
        }
        bCouldBeSeenByPlayer = false;
        dwLightSources = 0;
      }

      void CalcColors()
      {
        for ( int i = 0; i < 4; ++i )
        {
          if ( fLightPower[i] < 0.0f )
          {
            fLightPower[i] = 0.0f;
          }
          if ( fLightPower[i] > 1.0f )
          {
            fLightPower[i] = 1.0f;
          }
          int   iFactor = (int)( fLightPower[i] * 255.0f );
          dwColor[i] = 0xff000000 + ( iFactor << 16 ) + ( iFactor << 8 ) + iFactor;
        }
      }
    };

    typedef std::list<CGameObject*>   tListObjects;

    tListObjects                  m_listObjects;


    Light::eTextureSections*      m_pData;

    tTileInfo*                    m_pTileInfo;

    Light::eCaughtReason          m_CaughtReason;

    int                           m_iWidth;
    int                           m_iHeight;

    float                         m_fOffsetX,
                                  m_fOffsetY;

    bool                          m_bFullyLit,
                                  m_bLevelDone,
                                  m_bPlayerHasBeenCaught,
                                  m_bCentered;

    D3DXVECTOR3                   m_vectCenterTarget;


    CLevel();
    ~CLevel();

    void                          Initialize( int iWidth, int iHeight );
    void                          Reset();

    Light::eTextureSections       GetField( int iX, int iY );
    tTileInfo&                    GetTileInfo( int iX, int iY );
    void                          SetField( int iX, int iY, Light::eTextureSections fType );

    void                          Display( IDirect3DDevice8* pDevice );

    void                          Update( const float fElapsedTime );

    void                          Scroll( float fX, float fY );
    void                          ScrollTo( float fX, float fY );

    bool                          Load( DWORD dwNr );
    void                          Save( DWORD dwNr );

    CPlayer*                      Player();

    CGameObject*                  FindObjectAt( int iX, int iY );
    bool                          MoveObject( CGameObject* pObj, D3DXVECTOR3 vectDelta, CGameObject*& pObjRunInto );

    void                          CalcShadows();
    void                          CastLightRay( D3DXVECTOR3 vectSource, 
                                                float fStartAngle, 
                                                float fEndAngle, 
                                                float fMaxLength,
                                                Light::eLightSource );
    void                          TilesInSight( D3DXVECTOR3 vectSource, float fStartAngle, float fEndAngle, float fMaxLength, 
                                                std::set<std::pair<int,int> >& setTilesInSight );

    void                          SetEdgeLights( int iMapX, int iMapY, D3DXVECTOR3 vectSource, float fMaxLength );

    bool                          IsBlocked( int iX, int iY );

    bool                          IsAreaBlocked( CGameObject* pObjToCheck, int iX, int iY, int iWidth, int iHeight, CGameObject*& pObjRunInto );

    bool                          CanBeHeardByGuard( D3DXVECTOR3 vectPosition, float fSoundRadius );

};
