#include ".\guard.h"
#include ".\Level.h"
#include ".\Player.h"
#include ".\LightAndDark.h"



CGuard::CGuard() :
  m_State( GS_WALKING_DOWN ),
  m_fStateTime( 0.0f )
{

  m_Type = Light::OT_GUARD;
  m_tsImage = Light::TS_GUARD_STAND;
  SetRect( &m_rcCollision, 0, 0, 40, 40 );

  m_fLightBaseValue = 0.7f;

}



CGuard::~CGuard()
{
}



void CGuard::Update( const float fElapsedTime, CLevel& Level )
{

  float   fPrevStateTime = m_fStateTime;
  m_fStateTime += fElapsedTime;

  CPlayer*    pPlayer = Level.Player();

  CGameObject*    pDummy;

  switch ( m_State )
  {
    case GS_WAITING:
      return;
    case GS_TURNING_TOP:
      m_fAngle += 90.0f * fElapsedTime;
      if ( m_fAngle >= m_fTurnTargetAngle )
      {
        m_fAngle = m_fTurnTargetAngle;
        m_State = GS_WALKING_DOWN;
      }
      break;
    case GS_WALKING_DOWN:
      if ( !Level.MoveObject( this, Direction() * 30.0f * fElapsedTime, pDummy ) )
      {
        m_fTurnTargetAngle = m_fAngle + 180.0f;
        m_State = GS_TURNING_BOTTOM;
      }
      else if ( pPlayer )
      {
        // step sounds
        if ( (int)( fPrevStateTime / 1.0f ) < (int)( m_fStateTime / 1.0f ) )
        {
          float   fDistance = D3DXVec3Length( &( m_vectPosition - pPlayer->m_vectPosition ) );
          if ( fDistance < 640.0f )
          {
            D3DXVECTOR3   vectOffset = m_vectPosition - pPlayer->m_vectPosition;

            theApp.m_pSoundStep->SetPan( (LONG)( vectOffset.x * 10000 / 640.0f ) );
            theApp.m_pSoundStep->SetVolume( (LONG)( -fDistance * 500 / 640.0f ) );
            theApp.m_pSoundStep->Play( 0, 0, 0 );
          }
        }
      }
      break;
    case GS_TURNING_BOTTOM:
      m_fAngle += 90.0f * fElapsedTime;
      if ( m_fAngle >= m_fTurnTargetAngle )
      {
        m_fAngle = m_fTurnTargetAngle;
        m_State = GS_WALKING_UP;
      }
      break;
    case GS_WALKING_UP:
      if ( !Level.MoveObject( this, Direction() * 30.0f * fElapsedTime, pDummy ) )
      {
        m_fTurnTargetAngle = m_fAngle + 180.0f;
        m_State = GS_TURNING_TOP;
      }
      else if ( pPlayer )
      {
        // step sounds
        if ( (int)( fPrevStateTime / 1.0f ) < (int)( m_fStateTime / 1.0f ) )
        {
          float   fDistance = D3DXVec3Length( &( m_vectPosition - pPlayer->m_vectPosition ) );
          if ( fDistance < 640.0f )
          {
            D3DXVECTOR3   vectOffset = m_vectPosition - pPlayer->m_vectPosition;

            theApp.m_pSoundStep->SetPan( (LONG)( vectOffset.x * 10000 / 640.0f ) );
            theApp.m_pSoundStep->SetVolume( (LONG)( -fDistance * 500 / 640.0f ) );
            theApp.m_pSoundStep->Play( 0, 0, 0 );
          }
        }
      }
      break;
    case GS_TURNING_TO_PLAYER:
      m_fAngle += 90.0f * fElapsedTime;
      if ( m_fAngle >= m_fTurnTargetAngle )
      {
        m_fAngle = m_fTurnTargetAngle;
        m_State = GS_WAITING;
        m_tsImage = Light::TS_GUARD_STAND;
      }
      return;
  }

  if ( m_State != GS_WAITING )
  {
    // animate the guard
    m_fAnimPosition += fElapsedTime;
    if ( m_fAnimPosition >= 1.0f )
    {
      m_fAnimPosition -= 1.0f;
    }
    m_tsImage = m_fAnimPosition >= 0.5f ? Light::TS_GUARD_WALK_1 : Light::TS_GUARD_WALK_2;
  }


  std::set<std::pair<int,int> >   setVisibleTiles;

  Level.TilesInSight( m_vectPosition, m_fAngle - 30.0f, m_fAngle + 30.0f, 250.0f, setVisibleTiles );

  std::set<std::pair<int,int> >::iterator   it( setVisibleTiles.begin() );
  while ( it != setVisibleTiles.end() )
  {
    std::pair<int,int>& Pair = *it;

    CLevel::tTileInfo&    tileInfo = Level.GetTileInfo( Pair.first, Pair.second );

    if ( ( tileInfo.dwLightSources & Light::LS_PLAYER_LIGHT )
    ||   ( ( tileInfo.dwLightSources & Light::LS_PLAYER_OBJECT )
    &&     ( tileInfo.dwLightSources != Light::LS_PLAYER_OBJECT ) ) )
    {
      if ( tileInfo.dwLightSources & Light::LS_PLAYER_LIGHT )
      {
        if ( ( tileInfo.fLightPower[0] >= 0.2f )
        ||   ( tileInfo.fLightPower[1] >= 0.2f )
        ||   ( tileInfo.fLightPower[2] >= 0.2f )
        ||   ( tileInfo.fLightPower[3] >= 0.2f ) )
        {
          //Level.SetField( Pair.first, Pair.second, Light::TS_LAMP );
        }
        else
        {
          // not bright enough
          ++it;
          continue;
        }
      }
      // saw the player or his light!
      Level.m_bFullyLit             = true;
      Level.m_bPlayerHasBeenCaught  = true;
      Level.m_bCentered             = false;

      if ( tileInfo.dwLightSources & Light::LS_PLAYER_OBJECT )
      {
        Level.m_CaughtReason = Light::CR_SEEN;
      }
      else
      {
        Level.m_CaughtReason = Light::CR_SEEN_LIGHT;
      }

      theApp.m_pSoundCaught->Play( 0, 0, 0 );

      // center between player and guard
      Level.m_vectCenterTarget = ( m_vectPosition + pPlayer->m_vectPosition ) * 0.5f - D3DXVECTOR3( 320.0f, 240.0f, 0.0f );

      if ( pPlayer )
      {
        TurnToPosition( pPlayer->m_vectPosition );
      }
      break;
    }

    ++it;
  }

}



void CGuard::TurnToPosition( D3DXVECTOR3 vectPos )
{
  
  m_State = GS_TURNING_TO_PLAYER;

  m_fTurnTargetAngle = 180.0f / 3.1415926f * atan2f( m_vectPosition.y - vectPos.y ,
                                                     vectPos.x - m_vectPosition.x );
  while ( m_fAngle > 180.0f )
  {
    m_fAngle -= 360.0f;
  }
  while ( m_fAngle < -180.0f )
  {
    m_fAngle += 360.0f;
  }

}