#pragma once

#include <d3dx8.h>

#include "LightTypes.h"



class CLevel;

class CGameObject
{

  public:

    Light::eTextureSections   m_tsImage;

    D3DXVECTOR3               m_vectPosition;

    float                     m_fAngle,
                              m_fAnimPosition,
                              m_fLightBaseValue; // ensuring a flickerfree base light value for the object

    Light::eGameObjectType    m_Type;

    RECT                      m_rcCollision;


    CGameObject();
    virtual ~CGameObject();

    virtual void              Display( IDirect3DDevice8* pDevice, CLevel& Level );

    virtual void              Update( const float fElapsedTime, CLevel& Level );

    static CGameObject*       FromType( Light::eGameObjectType eType );

    virtual RECT              CollisionRect();

    D3DXVECTOR3               Direction();

};
