#include ".\gameobject.h"
#include ".\Level.h"
#include ".\LightAndDark.h"

#include ".\Player.h"
#include ".\Lamp.h"
#include ".\Guard.h"
#include ".\KeyCard.h"
#include ".\Toilet.h"
#include ".\Desk.h"
#include ".\Cupboard.h"
#include ".\FlowerBox.h"
#include ".\Chair.h"
#include ".\Couch.h"
#include ".\WallLight.h"
#include ".\WaterFountain.h"
#include ".\SmallTable.h"

#include ".\Util.h"



CGameObject::CGameObject() :
  m_Type( Light::OT_INVALID ),
  m_tsImage( Light::TS_EMPTY ),
  m_fAngle( 0.0f ),
  m_vectPosition( 0, 0, 0 ),
  m_fAnimPosition( 0.0f ),
  m_fLightBaseValue( 0.0f )
{
  SetRect( &m_rcCollision, 0, 0, 40, 40 );
}

CGameObject::~CGameObject(void)
{
}



void CGameObject::Display( IDirect3DDevice8* pDevice, CLevel& Level )
{

  CLevel::tTileInfo& TileInfo = Level.GetTileInfo( (int)m_vectPosition.x / 32, (int)m_vectPosition.y / 32 );

  // recalc the light power of the object (from the tile light below)
  float   fPower = 0.0f;
  if ( Level.m_bFullyLit )
  {
    // there's light everywhere
    fPower = 4.0f;
  }
  else
  {
    for ( int i = 0; i < 4; ++i )
    {
      fPower += TileInfo.fLightPower[i];
    }
    if ( m_fLightBaseValue > 0.0f )
    {
      // overriding the surrounding light by our own value
      fPower = 4.0f * m_fLightBaseValue;
    }
  }
  fPower *= 0.25f;
  DWORD dwColor = Util::ColorFromFloat( fPower, fPower, fPower );

  theApp.RenderTextureSectionRotated( (int)m_vectPosition.x - (int)Level.m_fOffsetX, 
                                      (int)m_vectPosition.y - (int)Level.m_fOffsetY,
                                      theApp.m_TexSec[m_tsImage],
                                      m_fAngle,
                                      dwColor );

}



void CGameObject::Update( const float fElapsedTime, CLevel& Level )
{
}



CGameObject* CGameObject::FromType( Light::eGameObjectType eType )
{

  switch ( eType )
  {
    case Light::OT_PLAYER:
      return new CPlayer();
    case Light::OT_LAMP:
      return new CLamp();
    case Light::OT_GUARD:
      return new CGuard();
    case Light::OT_KEYCARD:
      return new CKeyCard();
    case Light::OT_TOILET:
      return new CToilet();
    case Light::OT_DESK:
      return new CDesk();
    case Light::OT_CUPBOARD:
      return new CCupboard();
    case Light::OT_FLOWERBOX:
      return new CFlowerBox();
    case Light::OT_CHAIR:
      return new CChair();
    case Light::OT_COUCH:
      return new CCouch();
    case Light::OT_WALL_LIGHT:
      return new CWallLight();
    case Light::OT_WATER_FOUNTAIN:
      return new CWaterFountain();
    case Light::OT_SMALL_TABLE:
      return new CSmallTable();
    default:
      return NULL;
  }

  return NULL;

}



RECT CGameObject::CollisionRect()
{

  RECT        rcColl = m_rcCollision;

  OffsetRect( &rcColl, (int)m_vectPosition.x - rcColl.right / 2, (int)m_vectPosition.y - rcColl.bottom / 2 );

  return rcColl;

}



D3DXVECTOR3 CGameObject::Direction()
{

  D3DXVECTOR3   vectDir;

  vectDir.x = cosf( m_fAngle * 3.1415926f / 180.0f );
  vectDir.y = -sinf( m_fAngle * 3.1415926f / 180.0f );
  vectDir.z = 0.0f;

  return vectDir;

}