#include <d3d8.h>

#include ".\gsmenu.h"
#include ".\LightAndDark.h"
#include ".\GSEdit.h"
#include ".\GSGame.h"
#include ".\GSInstructions.h"
#include ".\Util.h"



CGSMenu::CGSMenu() :
  m_fSilentX( -640.0f ),
  m_fHunterX( 960.0f ),
  m_fStateTime( 0.0f ),
  m_iSelectedItem( 0 )
{

}

CGSMenu::~CGSMenu(void)
{
}



void CGSMenu::Display( IDirect3DDevice8* pDevice )
{

  theApp.m_IntroLevel.Display( pDevice );

  theApp.RenderTextureSection( (int)m_fSilentX, 20, theApp.m_TexSec[Light::TS_SILENT] );
  theApp.RenderTextureSection( (int)m_fHunterX, 90, theApp.m_TexSec[Light::TS_HUNTER] );

  if ( m_fStateTime >= 5.0f )
  {
    DWORD   dwColor = 0xffffc000;
    
    if ( m_fStateTime < 6.0f )
    {
      dwColor = Util::ColorFromFloat( m_fStateTime - 5.0f, ( m_fStateTime - 5.0f ) * 0.8f, 0.0f );
    }
    theApp.PrintNiceCentered( 320, 200, "Written by Georg Rottensteiner", dwColor );
  }
  theApp.PrintNiceCentered( 320, 260, "Start Game", 
                            ( m_iSelectedItem == 0 ) ? 0xff80ff80 : 0xff008000, 
                            m_iSelectedItem == 0 );
  theApp.PrintNiceCentered( 320, 310, "Editor",     
                            ( m_iSelectedItem == 1 ) ? 0xff80ff80 : 0xff008000,       
                            m_iSelectedItem == 1 );
  theApp.PrintNiceCentered( 320, 360, "Instructions", 
                            ( m_iSelectedItem == 2 ) ? 0xff80ff80 : 0xff008000, 
                            m_iSelectedItem == 2 );
  theApp.PrintNiceCentered( 320, 410, "Quit Game", 
                            ( m_iSelectedItem == 3 ) ? 0xff80ff80 : 0xff008000,    
                            m_iSelectedItem == 3 );

  theApp.Print( 5, 460, "http://www.ludumdare.com 48h Competition April 2005 Entry, visit http://www.georg-rottensteiner.de for more" );

}



void CGSMenu::UpdateFrame( const float fElapsedTime )
{

  theApp.m_IntroLevel.Update( fElapsedTime );

  m_fStateTime += fElapsedTime;

  if ( ( m_fStateTime >= 2.0f )
  &&   ( m_fStateTime < 5.0f ) )
  {
    m_fSilentX = -630.0f + 800.0f * sinf( ( m_fStateTime - 2.0f ) * 3.1415926f / 6.0f );
    m_fHunterX = 1010.0f - 800.0f * sinf( ( m_fStateTime - 2.0f ) * 3.1415926f / 6.0f );
  }
  else if ( m_fStateTime >= 5.0f )
  {
    m_fSilentX = -630.0f + 800.0f;
    m_fHunterX = 1010.0f - 800.0f;
  }

}


void CGSMenu::OnChar( int iChar )
{

  if ( iChar == 'e' )
  {
    theApp.NextState( new CGSEdit() );
  }
  else if ( iChar == 'p' )
  {
    theApp.NextState( new CGSGame() );
  }
  else if ( iChar == 27 )
  {
    PostMessage( theApp.m_hWnd, WM_CLOSE, 0, 0 );
  }
  else if ( ( iChar == ' ' )
  ||        ( iChar == 13 ) )
  {
    switch ( m_iSelectedItem )
    {
      case 0:
        theApp.NextState( new CGSGame() );
        break;
      case 1:
        theApp.NextState( new CGSEdit() );
        break;
      case 2:
        theApp.NextState( new CGSInstructions() );
        break;
      case 3:
        PostMessage( theApp.m_hWnd, WM_CLOSE, 0, 0 );
        break;
    }
  }

}



void CGSMenu::OnKeyDown( int iChar )
{

  if ( iChar == VK_DOWN )
  {
    m_iSelectedItem = ( m_iSelectedItem + 1 ) % 4;
  }
  if ( iChar == VK_UP )
  {
    m_iSelectedItem = ( m_iSelectedItem + 4 - 1 ) % 4;
  }

}