#include <d3d8.h>

#include ".\GSInstructions.h"
#include ".\GSMenu.h"
#include ".\LightAndDark.h"
#include ".\GameObject.h"



CGSInstructions::CGSInstructions()
{

}



CGSInstructions::~CGSInstructions()
{
}



void CGSInstructions::Display( IDirect3DDevice8* pDevice )
{

  theApp.m_IntroLevel.Display( pDevice );

  theApp.PrintNiceCentered( 320, 20, "Instructions for Silent Hunter", 0xff008000 );

  DWORD dwColor = 0xffa0a0a0;

  theApp.PrintNice( 20,  70, "Your name is not of importance. Your mission is simple:", dwColor );
  theApp.PrintNice( 20, 100, "Top secret data has been separated and hidden in several", dwColor );
  theApp.PrintNice( 20, 130, "countries. Break into the buildings and retrieve the", dwColor );
  theApp.PrintNice( 20, 160, "secret data. The data is usually kept in a green cabinet.", dwColor );
  theApp.PrintNice( 20, 190, "You must not be detected. Go inside unseen and find the", dwColor );
  theApp.PrintNice( 20, 220, "cabinet. Once a guard sees something suspicious like a light", dwColor );
  theApp.PrintNice( 20, 250, "which doesn't belong or hears a sound he will start the alarm.", dwColor );
  theApp.PrintNice( 20, 280, "Once the alarm is on you cannot escape. We will have to", dwColor );
  theApp.PrintNice( 20, 310, "deny any knowledge.", dwColor );
  theApp.PrintNice( 20, 340, "Use the cursor keys to move, L to switch your flashlight on", dwColor );
  theApp.PrintNice( 20, 370, "and off and SPACE to open doors with keycards. You will need", dwColor );
  theApp.PrintNice( 20, 400, "to find keycards inside the buildings yourself.", dwColor );
  theApp.PrintNice( 20, 440, "Good luck! You'll need it.", dwColor );

}



void CGSInstructions::UpdateFrame( const float fElapsedTime )
{

  theApp.m_IntroLevel.Update( fElapsedTime );

}



void CGSInstructions::OnChar( int iChar )
{

  if ( ( iChar == 27 )
  ||   ( iChar == ' ' )
  ||   ( iChar == 13 ) )
  {
    theApp.NextState( new CGSMenu() );
  }

}



void CGSInstructions::OnKeyDown( int iChar )
{

}