#include <d3d8.h>

#include ".\GSGame.h"
#include ".\GSMenu.h"
#include ".\Player.h"
#include ".\LightAndDark.h"



CGSGame::CGSGame() :
  m_pPlayer( NULL ),
  m_iSelectedItem( 0 ),
  m_bRetryMenu( false ),
  m_bWellDone( false ),
  m_bCompleted( false ),
  m_fCompletedDelayTime( 0.0f )
{

  m_dwLevel = 1;
  if ( !m_Level.Load( m_dwLevel ) )
  {
    theApp.NextState( new CGSMenu() );
  }

  m_pPlayer = m_Level.Player();

  if ( m_pPlayer )
  {
    m_Level.ScrollTo( m_pPlayer->m_vectPosition.x - 320.0f, m_pPlayer->m_vectPosition.y - 240.0f );
  }

  m_fCompleteElapsedTime = 0.0f;
  m_dwFrames = 0;

}

CGSGame::~CGSGame()
{
}



void CGSGame::Display( IDirect3DDevice8* pDevice )
{

  ++m_dwFrames;

  m_Level.Display( pDevice );

  char    szTemp[MAX_PATH];
  if ( ( m_pPlayer )
  &&   ( !m_bCompleted )
  &&   ( !m_bWellDone ) )
  {
    wsprintf( szTemp, "Keycards: %d", m_pPlayer->m_dwKeyCards );
    theApp.PrintNice( 5, 5, szTemp, 0xff00c000 );
  }

  /*
  wsprintf( szTemp, "FPS: %d", (int)( m_dwFrames * 1000 / m_fCompleteElapsedTime ) );
  theApp.PrintNice( 320, 5, szTemp );
  */

  if ( m_Level.m_bPlayerHasBeenCaught )
  {
    switch ( m_Level.m_CaughtReason )
    {
      case Light::CR_HEARD:
        theApp.PrintNiceCentered( 320, 100, "You have been heard by the guard!", 0xffff4040 );
        break;
      case Light::CR_SEEN:
        theApp.PrintNiceCentered( 320, 100, "You have been seen by the guard!", 0xffff4040 );
        break;
      case Light::CR_SEEN_LIGHT:
        theApp.PrintNiceCentered( 320, 100, "Your flashlight has been seen by the guard!", 0xffff4040 );
        break;
    }

    theApp.PrintNiceCentered( 320, 200, "Retry Mission", 
                              ( m_iSelectedItem == 0 ) ? 0xff80ff80 : 0xff00c000, 
                              m_iSelectedItem == 0 );
    theApp.PrintNiceCentered( 320, 230, "Give Up",     
                              ( m_iSelectedItem == 1 ) ? 0xff80ff80 : 0xff00c000,       
                              m_iSelectedItem == 1 );
  }
  else if ( m_bCompleted )
  {
    theApp.PrintNiceCentered( 320, 20, "All 10 data pieces retrieved", 0xff008000 );

    DWORD dwColor = 0xffa0a0a0;

    theApp.PrintNice( 20,  70, "Congratulations! You have retrieved the 10 pieces we", dwColor );
    theApp.PrintNice( 20, 100, "were able to locate. Our scientists will analyse the data", dwColor );
    theApp.PrintNice( 20, 130, "right now. You have done a very good job!", dwColor );
    theApp.PrintNice( 20, 190, "But these were not all the data pieces we're looking for.", dwColor );
    theApp.PrintNice( 20, 220, "We have yet to locate the rest. Until then you will be", dwColor );
    theApp.PrintNice( 20, 250, "our guest.", dwColor );

    if ( m_fCompletedDelayTime >= 10.0f )
    {
      theApp.PrintNiceCentered( 320, 440, "Press SPACE or RETURN", 0xffc0c0c0 );
    }
  }
  else if ( m_bWellDone )
  {
    theApp.PrintNiceCentered( 320, 220, "Mission Completed", 0xffc0c0c0 );
  }

}



void CGSGame::UpdateFrame( const float fElapsedTime )
{

  if ( ( m_Level.m_bPlayerHasBeenCaught )
  &&   ( !m_bRetryMenu ) )
  {
    // show retry menu if we've been caught
    m_bRetryMenu = true;
    m_iSelectedItem = 0;
  }


  m_fCompleteElapsedTime += fElapsedTime;

  m_Level.Update( fElapsedTime );
  if ( ( m_pPlayer )
  &&   ( !m_Level.m_bPlayerHasBeenCaught )
  &&   ( !m_bCompleted )
  &&   ( !m_bWellDone ) )
  {
    if ( theApp.m_bKeyPressed[VK_LEFT] )
    {
      m_pPlayer->m_fAngle += 220.0f * fElapsedTime;
    }
    if ( theApp.m_bKeyPressed[VK_RIGHT] )
    {
      m_pPlayer->m_fAngle -= 220.0f * fElapsedTime;
    }
    if ( ( theApp.m_bKeyPressed['L'] )
    &&   ( theApp.m_bKeyReleased['L'] ) )
    {
      // Toggling flashlight
      m_pPlayer->m_bFlashLightOn = !m_pPlayer->m_bFlashLightOn;

      m_pPlayer->m_fLightBaseValue = m_pPlayer->m_bFlashLightOn ? 0.75f : 0.0f;

      theApp.m_bKeyReleased['L'] = false;

      theApp.m_pSoundClick->Play( 0, 0, 0 );

      m_Level.CanBeHeardByGuard( m_pPlayer->m_vectPosition, 120.0f );
    }
    if ( ( theApp.m_bKeyPressed[VK_SPACE] )
    &&   ( theApp.m_bKeyReleased[VK_SPACE] ) )
    {
      PlayerAction();
      theApp.m_bKeyReleased[VK_SPACE] = false;
    }
    if ( theApp.m_bKeyPressed[VK_UP] )
    {
      // move forward
      D3DXVECTOR3     vectDir;

      vectDir.x = cosf( 3.1415926f * m_pPlayer->m_fAngle / 180.0f );
      vectDir.y = -sinf( 3.1415926f * m_pPlayer->m_fAngle / 180.0f );
      vectDir.z = 0.0f;

      CGameObject*    pObjRunInto = NULL;

      m_Level.MoveObject( m_pPlayer, 120.0f * vectDir * fElapsedTime, pObjRunInto );

      if ( ( pObjRunInto )
      &&   ( pObjRunInto->m_Type != Light::OT_WALL_LIGHT ) )
      {
        theApp.m_pSoundCrash->Play( 0, 0, 0 );

        // can a guard hear us?
        m_Level.CanBeHeardByGuard( m_pPlayer->m_vectPosition, 250.0f );
      }

      m_pPlayer->m_fAnimPosition += fElapsedTime;
      if ( m_pPlayer->m_fAnimPosition >= 0.5f )
      {
        m_pPlayer->m_fAnimPosition -= 0.5f;
      }
      m_pPlayer->m_tsImage = m_pPlayer->m_fAnimPosition >= 0.25f ? Light::TS_PLAYER_WALK_1 : Light::TS_PLAYER_WALK_2;
    }
    else if ( theApp.m_bKeyPressed[VK_DOWN] )
    {
      // move backward
      D3DXVECTOR3     vectDir;

      vectDir.x = cosf( 3.1415926f * m_pPlayer->m_fAngle / 180.0f );
      vectDir.y = -sinf( 3.1415926f * m_pPlayer->m_fAngle / 180.0f );
      vectDir.z = 0.0f;

      CGameObject*    pObjRunInto = NULL;

      m_Level.MoveObject( m_pPlayer, -120.0f * vectDir * fElapsedTime, pObjRunInto );

      if ( ( pObjRunInto )
      &&   ( pObjRunInto->m_Type != Light::OT_WALL_LIGHT ) )
      {
        theApp.m_pSoundCrash->Play( 0, 0, 0 );

        // can a guard hear us?
        m_Level.CanBeHeardByGuard( m_pPlayer->m_vectPosition, 250.0f );
      }

      m_pPlayer->m_fAnimPosition += fElapsedTime;
      if ( m_pPlayer->m_fAnimPosition >= 0.5f )
      {
        m_pPlayer->m_fAnimPosition -= 0.5f;
      }
      m_pPlayer->m_tsImage = m_pPlayer->m_fAnimPosition >= 0.25f ? Light::TS_PLAYER_WALK_1 : Light::TS_PLAYER_WALK_2;
    }
    else
    {
      m_pPlayer->m_tsImage = Light::TS_PLAYER_STAND;
    }
    m_Level.ScrollTo( m_pPlayer->m_vectPosition.x - 320.0f, m_pPlayer->m_vectPosition.y - 240.0f );
  }

  if ( ( m_Level.m_bLevelDone )
  &&   ( !m_bWellDone ) )
  {
    m_bWellDone = true;
  }

  if ( m_bCompleted )
  {
    m_fCompletedDelayTime += fElapsedTime;
  }

}



void CGSGame::OnChar( int iChar )
{

  static char   szCheat[5] = "\0\0\0\0";

  memcpy( szCheat, szCheat + 1, 4 );
  szCheat[4] = iChar;

  if ( ( szCheat[0] == 'g' )
  &&   ( szCheat[1] == 'e' )
  &&   ( szCheat[2] == 'o' )
  &&   ( szCheat[3] == 'r' )
  &&   ( szCheat[4] == 'g' ) )
  {
    // Cheater!
    m_bWellDone = true;
  }
  if ( ( szCheat[0] == 'w' )
  &&   ( szCheat[1] == 'i' )
  &&   ( szCheat[2] == 'l' )
  &&   ( szCheat[3] == 'l' )
  &&   ( szCheat[4] == 'i' ) )
  {
    // Cheater!
    m_bCompleted = true;
    m_fCompletedDelayTime = 0.0f;
  }

  if ( iChar == 27 )
  {
    theApp.NextState( new CGSMenu() );
  }
  else if ( ( iChar == ' ' )
  ||        ( iChar == 13 ) )
  {
    if ( m_bRetryMenu )
    {
      switch ( m_iSelectedItem )
      {
        case 0:
          m_Level.Load( m_dwLevel );
          m_pPlayer = m_Level.Player();
          m_Level.ScrollTo( m_pPlayer->m_vectPosition.x - 320.0f, m_pPlayer->m_vectPosition.y - 240.0f );
          m_bWellDone = false;
          m_bRetryMenu = false;
          break;
        case 1:
          theApp.NextState( new CGSMenu() );
          break;
      }
    }
    else if ( m_bCompleted )
    {
      if ( m_fCompletedDelayTime >= 10.0f )
      {
        theApp.NextState( new CGSMenu() );
      }
    }
    else if ( m_bWellDone )
    {
      m_dwLevel++;
      m_pPlayer = NULL;
      if ( !m_Level.Load( m_dwLevel ) )
      {
        m_bCompleted = true;
        m_fCompletedDelayTime = 0.0f;
      }
      else
      {
        m_pPlayer = m_Level.Player();
        m_Level.ScrollTo( m_pPlayer->m_vectPosition.x - 320.0f, m_pPlayer->m_vectPosition.y - 240.0f );
        m_bWellDone = false;
      }
    }
  }

}



void CGSGame::PlayerAction()
{

  D3DXVECTOR3     vectDir;

  vectDir.x = cosf( 3.1415926f * m_pPlayer->m_fAngle / 180.0f );
  vectDir.y = -sinf( 3.1415926f * m_pPlayer->m_fAngle / 180.0f );
  vectDir.z = 0.0f;

  D3DXVECTOR3     vectPos = m_pPlayer->m_vectPosition + 40.0f * vectDir;

  int     iX = (int)vectPos.x / 32;
  int     iY = (int)vectPos.y / 32;

  Light::eTextureSections   tsField = m_Level.GetField( iX, iY );

  if ( ( tsField == Light::TS_DOOR_H )
  ||   ( tsField == Light::TS_DOOR_V ) )
  {
    // Tr ffnen
    if ( m_pPlayer->m_dwKeyCards )
    {
      Light::eTextureSections   tsFloorUnderDoor = m_Level.GetField( (int)m_pPlayer->m_vectPosition.x / 32, 
                                                                     (int)m_pPlayer->m_vectPosition.y / 32 );
      if ( tsField == Light::TS_DOOR_H )
      {
        while ( m_Level.GetField( iX - 1, iY ) == Light::TS_DOOR_H )
        {
          --iX;
        }
        int   iX1 = iX;
        while ( m_Level.GetField( iX + 1, iY ) == Light::TS_DOOR_H )
        {
          ++iX;
        }
        for ( int i = iX1; i <= iX; ++i )
        {
          m_Level.SetField( i, iY, tsFloorUnderDoor );
        }
        --m_pPlayer->m_dwKeyCards;

        theApp.m_pSoundSwipe->Play( 0, 0, 0 );
        m_Level.CanBeHeardByGuard( m_pPlayer->m_vectPosition, 110.0 );
      }
      else if ( tsField == Light::TS_DOOR_V )
      {
        while ( m_Level.GetField( iX, iY - 1 ) == Light::TS_DOOR_V )
        {
          --iY;
        }
        int   iY1 = iY;
        while ( m_Level.GetField( iX, iY + 1 ) == Light::TS_DOOR_V )
        {
          ++iY;
        }
        for ( int i = iY1; i <= iY; ++i )
        {
          m_Level.SetField( iX, i, tsFloorUnderDoor );
        }
        --m_pPlayer->m_dwKeyCards;

        theApp.m_pSoundSwipe->Play( 0, 0, 0 );
        m_Level.CanBeHeardByGuard( m_pPlayer->m_vectPosition, 110.0 );
      }
    }
  }

}



void CGSGame::OnKeyDown( int iChar )
{

  if ( m_bRetryMenu )
  {
    if ( iChar == VK_DOWN )
    {
      m_iSelectedItem = ( m_iSelectedItem + 1 ) % 2;
    }
    if ( iChar == VK_UP )
    {
      m_iSelectedItem = ( m_iSelectedItem + 2 - 1 ) % 2;
    }
  }

}