#pragma once

#include <vector>

#include "gamestate.h"

#include "LightTypes.h"
#include "Level.h"



class CGSEdit : public CGameState
{

  public:

    typedef std::vector<Light::eTextureSections>    tVectEditTiles;


    CLevel                  m_Level;

    size_t                  m_iCurrentEditTile;

    Light::eGameObjectType  m_oType;

    tVectEditTiles          m_vectEditTiles;

    bool                    m_bTileMode;

    int                     m_iMouseX,
                            m_iMouseY;

    bool                    m_bMouseButtonReleased;

    DWORD                   m_dwLevel;

    CGameObject*            m_pCurrentObject;

    CGameObject*            m_pSelectedObject;


    CGSEdit();
    virtual ~CGSEdit();

    virtual void            Display( IDirect3DDevice8* pDevice );

    virtual void            UpdateFrame( const float fElapsedTime );

    virtual void            OnChar( int iChar );
    virtual void            OnKeyDown( int iChar );

    virtual void            OnMouse( int iX, int iY, int iButtons );

    void                    AutoWall();
    bool                    IsFloorBeside( int iX, int iY );

};
