#include <algorithm>

#include ".\desk.h"



CDesk::CDesk()
{
  m_Type    = Light::OT_DESK;
  m_tsImage = Light::TS_DESK;
  SetRect( &m_rcCollision, 0, 0, 100, 40 );
}

CDesk::~CDesk(void)
{
}



RECT CDesk::CollisionRect()
{

  RECT        rcColl = CGameObject::CollisionRect();

  float   fAngle = m_fAngle;
  while ( fAngle >= 360.0f )
  {
    fAngle -= 360.0;
  }
  while ( fAngle < 0.0f )
  {
    fAngle += 360.0;
  }
  if ( ( ( fAngle >= 45.0f )
  &&     ( fAngle <= 135.0f ) )
  ||   ( ( fAngle >= 225.0f )
  &&     ( fAngle <= 315.0f ) ) )
  {
    // turn the collision rect 90 degree (fakefakefake)
    rcColl = m_rcCollision;
    std::swap( rcColl.bottom, rcColl.right );
    OffsetRect( &rcColl, (int)m_vectPosition.x - rcColl.right / 2, (int)m_vectPosition.y - rcColl.bottom / 2 );
  }

  return rcColl;

}



