#include <algorithm>

#include ".\couch.h"



CCouch::CCouch()
{
  m_Type = Light::OT_COUCH;
  m_tsImage = Light::TS_COUCH;
  SetRect( &m_rcCollision, 0, 0, 100, 24 );
}

CCouch::~CCouch(void)
{
}



RECT CCouch::CollisionRect()
{

  RECT        rcColl = CGameObject::CollisionRect();

  float   fAngle = m_fAngle;
  while ( fAngle >= 360.0f )
  {
    fAngle -= 360.0;
  }
  while ( fAngle < 0.0f )
  {
    fAngle += 360.0;
  }
  if ( ( ( fAngle >= 45.0f )
  &&     ( fAngle <= 135.0f ) )
  ||   ( ( fAngle >= 225.0f )
  &&     ( fAngle <= 315.0f ) ) )
  {
    // turn the collision rect 90 degree (fakefakefake)
    rcColl = m_rcCollision;
    std::swap( rcColl.bottom, rcColl.right );
    OffsetRect( &rcColl, (int)m_vectPosition.x - rcColl.right / 2, (int)m_vectPosition.y - rcColl.bottom / 2 );
  }

  return rcColl;

}



