#pragma once

#include <Interface/IService.h>


#include  <string>

#include  <windows.h>
#include  <mmsystem.h>

#include  <dsound.h>

#include  <vorbis/codec.h>

#include  <vorbis/vorbisfile.h>



class CDirectSoundOgg
{

  private:

    std::string         m_strFilename;

    bool                m_bFileLoaded;

    bool                m_bLooping;

    bool                m_bPlaybackDone;

    bool                m_bPlayThreadActive;

    LPDIRECTSOUND       m_pDirectSound;

  protected:

    bool                GetPlayThreadActive();

    void                SetPlayThreadActive( bool bActive );

    OggVorbis_File      m_vorbisFile;

    LPDIRECTSOUNDBUFFER m_pBuffer;

    LPDIRECTSOUNDBUFFER m_pPrimarySoundBuffer;

    HWND                m_hwndMain;

    bool                m_bPaused;

    CRITICAL_SECTION    m_criticalSection;

    HANDLE              m_hPlayThread;
    
    HANDLE              m_hStopPlaybackEvent;

    DWORD               m_dwVolume;


    bool                Allocate();
    
    void                Cleanup();

    bool                Fill( const bool firstHalf );

    static unsigned int WINAPI PlayingThread(LPVOID lpParam);

  public:

    CDirectSoundOgg();

    virtual bool            Initialize( HWND hwndMain );

    virtual bool            Release();

    virtual bool            IsInitialized();

    virtual bool            SetVolume( int iVolume );
    virtual int             Volume();

    virtual bool            LoadMusic( const char* szFileName );

    //!Default destructor

    virtual ~CDirectSoundOgg();

    //!Returns the file to play

    std::string GetFileName();

    //!Returns true if the OGG is playing, otherwise false

    bool IsPlaying();

    //!Stops the OGG

    void Stop();

    //!Starts streaming the OGG

    virtual bool            Play( bool bLooped = true );

    virtual bool            Resume();
    virtual bool            Pause();

};
