#ifndef LD_TYPES_H
#define LD_TYPES_H

#include <string>



namespace LD
{
  enum TextureTypes
  {
    TEX_TILE_GRASS,
    TEX_TILE_SAND,

    TEX_UNIT_PLAYER,
    TEX_UNIT_SLIME,
    TEX_UNIT_SLIME_2,
    TEX_UNIT_SPIDER,
    TEX_UNIT_SPIDER_2,
    TEX_UNIT_JELLY,
    TEX_UNIT_JELLY_2,
    TEX_UNIT_BEAR,
    TEX_UNIT_BEAR_2,
    TEX_UNIT_BOSS,
    TEX_UNIT_BOSS_2,
    TEX_UNIT_OCTOPUS,
    TEX_UNIT_OCTOPUS_2,
    TEX_UNIT_CACODEMON,
    TEX_UNIT_CACODEMON_2,
    TEX_UNIT_BAT,
    TEX_UNIT_BAT_2,
    TEX_UNIT_KITTEN,
    TEX_UNIT_KITTEN_2,

    TEX_CHEST,

    TEX_FX_DAMAGE,
    TEX_FX_HEAL,
    TEX_FX_EXP,

    TEX_SLIME_RED,
    TEX_SLIME_GREEN,
    TEX_SLIME_BLUE,
    TEX_SLIME_YELLOW,

    TEX_LAST_ENTRY
  };

  enum GameObjectType
  {
    GO_INVALID = 0,
    GO_LAST_ENTRY,
  };

  enum SoundTypes
  {
    SOUND_ENEMY_ATTACK_1,
    SOUND_ENEMY_ATTACK_2,
    SOUND_ENEMY_ATTACK_3,
    SOUND_ENEMY_HIT,
    SOUND_PLAYER_ATTACK_1,
    SOUND_PLAYER_ATTACK_2,
    SOUND_PLAYER_ATTACK_3,
    SOUND_PLAYER_HIT,
    SOUND_LEVEL_UP,
    SOUND_OPEN_CHEST,
    SOUND_MAGIC,
    SOUND_PLAYER_KILLED,
    SOUND_ENEMY_KILLED,
    SOUND_MISS,
    SOUND_STEP,
    SOUND_LAST_ENTRY
  };
  
  enum TileType
  {
    TT_GRASS,
    TT_SAND,

    TT_MAX_ENTRIES
  };

  enum UnitType
  {
    UT_PLAYER,
    UT_SLIME,
    UT_SPIDER,
    UT_JELLY,
    UT_BEAR,
    UT_BOSS,
    UT_OCTOPUS,
    UT_KITTEN,
    UT_CACODEMON,
    UT_BAT,

    UT_CHEST,

    UT_FX_DAMAGE,
    UT_FX_EXP,
    UT_FX_HEAL,

    UT_FLOOR_SLIME_RED,
    UT_FLOOR_SLIME_GREEN,
    UT_FLOOR_SLIME_BLUE,
    UT_FLOOR_SLIME_YELLOW
  };

  struct Tile
  {
    TileType      Type;
    
    Tile() :
      Type( TT_GRASS )
    {
    }
  };

  struct Level
  {
    Tile        Tiles[10][10];
  };

  struct Unit
  {
    TextureTypes        Image;
    UnitType            Type;
    int                 X;
    int                 Y;
    bool                RemoveMe;
    int                 HP;
    int                 HPBonus;
    int                 Level;
    int                 DisplayValue;
    int                 LifeTime;
    int                 Attack;
    int                 Weapon;
    int                 Defense;
    int                 Armor;
    int                 TurnDelaySpeed;
    int                 TurnDelayPos;


    Unit( int X = 0, int Y = 0, UnitType Type = UT_PLAYER, TextureTypes Image = TEX_UNIT_PLAYER ) :
      Type( Type ),
      Image( Image ),
      X( X ),
      Y( Y ),
      RemoveMe( false ),
      HP( 1 ),
      HPBonus( 0 ),
      Level( 1 ),
      DisplayValue( 0 ),
      LifeTime( 0 ),
      Attack( 1 ),
      Defense( 1 ),
      Weapon( 0 ),
      Armor( 0 ),
      TurnDelaySpeed( 10 ),
      TurnDelayPos( 0 )
    {
    }
  };

  struct Message
  {
    std::string     Text[3];

    Message( const std::string& Text1, const std::string& Text2, const std::string& Text3 )
    {
      Text[0] = Text1;
      Text[1] = Text2;
      Text[2] = Text3;
    }
  };

};




#endif // LD_TYPES_H