#pragma once
#include "gamestate.h"
#include "LDTypes.h"

#include <vector>



class CGSMenu : public CGameState
{

  public:

    std::vector<std::pair<LD::TextureTypes,std::string> > m_DisplayUnits;

    int                     m_DisplayUnitDelay;
    int                     m_CurUnit;
    int                     m_AnimFrame;




    CGSMenu();
    virtual ~CGSMenu();

    virtual void            Display( IDirect3DDevice8* pDevice );

    virtual void            UpdateFixed();
    virtual void            UpdateFrame( const float fElapsedTime );

    virtual void            OnChar( int iChar );
    virtual void            OnKeyDown( int iChar );
    virtual void            OnMouse( int X, int Y, int Buttons );

};
