#include <d3d8.h>

#include ".\gsmenu.h"
#include ".\gsgame.h"
#include ".\LD.h"



CGSMenu::CGSMenu()
{
  theApp.m_Music.LoadMusic( "sounds/title.ogg" );
  theApp.m_Music.Play( true );

  m_DisplayUnitDelay = 0;
  m_CurUnit = 0;
  m_AnimFrame = 0;

  m_DisplayUnits.push_back( std::make_pair( LD::TEX_UNIT_PLAYER, "YOU" ) );
  m_DisplayUnits.push_back( std::make_pair( LD::TEX_CHEST, "CHEST" ) );
  m_DisplayUnits.push_back( std::make_pair( LD::TEX_UNIT_SLIME, "SLIME" ) );
  m_DisplayUnits.push_back( std::make_pair( LD::TEX_UNIT_SPIDER, "SPIDER" ) );
  m_DisplayUnits.push_back( std::make_pair( LD::TEX_UNIT_JELLY, "JELLY" ) );
  m_DisplayUnits.push_back( std::make_pair( LD::TEX_UNIT_BEAR, "BEAR" ) );
  m_DisplayUnits.push_back( std::make_pair( LD::TEX_UNIT_OCTOPUS, "OCTOPUS" ) );
  m_DisplayUnits.push_back( std::make_pair( LD::TEX_UNIT_KITTEN, "KITTEN" ) );
  m_DisplayUnits.push_back( std::make_pair( LD::TEX_UNIT_BAT, "BAT" ) );
  m_DisplayUnits.push_back( std::make_pair( LD::TEX_UNIT_CACODEMON, "CACODEMON" ) );
  m_DisplayUnits.push_back( std::make_pair( LD::TEX_UNIT_BOSS, "BOSS" ) );
}



CGSMenu::~CGSMenu(void)
{
}



void CGSMenu::Display( IDirect3DDevice8* pDevice )
{

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

  for ( int i = 0; i < 10; ++i )
  {
    for ( int j = 0; j < 11; ++j )
    {
      theApp.RenderTextureSectionAsTile2d( i * 32, j * 32, theApp.m_TexSec[LD::TEX_TILE_GRASS] );
    }
  }

  theApp.PrintNiceCentered( 161, 21, "IT'S A TINY WORLD", 0xff000000 );
  theApp.PrintNiceCentered( 160, 20, "IT'S A TINY WORLD" );

  theApp.PrintNumberCentered( 160, 100, "A MIGHTY BEAST TERRORIZES YOUR" );
  theApp.PrintNumberCentered( 160, 110, "TINY WORLD! PICK UP ARMS, BEST" );
  theApp.PrintNumberCentered( 160, 120, "ITS ARMY OF MONSTERS AND GAIN" );
  theApp.PrintNumberCentered( 160, 130, "THE STRENGTH TO BEAT IT." );

  theApp.PrintNumberCentered( 160, 150, "MOVE WITH CURSOR KEYS. RUN INTO" );
  theApp.PrintNumberCentered( 160, 160, "ENEMIES TO ATTACK THEM. BE CAREFUL" );
  theApp.PrintNumberCentered( 160, 170, "TO ONLY ATTACK MONSTERS YOU STAND" );
  theApp.PrintNumberCentered( 160, 180, "A CHANCE AGAINST. THE FINAL BOSS" );
  theApp.PrintNumberCentered( 160, 190, "WAITS IN THE BOTTOM RIGHT CORNER." );
  theApp.PrintNumberCentered( 160, 200, "LOOT CHESTS FOR EXTRA BONI. IF YOU" );
  theApp.PrintNumberCentered( 160, 210, "MANAGE TO LAY OUT ENEMIES BLOOD IN" );
  theApp.PrintNumberCentered( 160, 220, "THREE PUDDLES IN A ROW A MAGIC" );
  theApp.PrintNumberCentered( 160, 230, "SPELL IS CAST HELPING YOU ALONG." );

  theApp.PrintNumberCentered( 160, 320, "PRESS SPACE TO PLAY" );

  theApp.PrintNumberCentered( 160, 60, "GEORG \"ENDURION\" ROTTENSTEINER", 0xffa0a0a0 );
  theApp.PrintNumberCentered( 160, 70, "HTTP://WWW.GEORG-ROTTENSTEINER.DE", 0xffa0a0a0 );
  theApp.PrintNumberCentered( 160, 80, "SFX  SFXR   MUSIC  ATRK-BU", 0xffa0a0a0 );

  LD::TextureTypes    curTex = m_DisplayUnits[m_CurUnit].first;

  int     imageOffset = 0;
  if ( ( curTex != LD::TEX_CHEST )
  &&   ( curTex != LD::TEX_UNIT_PLAYER ) )
  {
    if ( ( m_AnimFrame ) % 32 >= 16 )
    {
      imageOffset = 1;
    }
  }
  theApp.RenderTextureSectionAsTile2d( 130, 270, theApp.m_TexSec[curTex + imageOffset] );
  theApp.PrintNumber( 170, 285, m_DisplayUnits[m_CurUnit].second.c_str() );
}



void CGSMenu::UpdateFrame( const float fElapsedTime )
{
  if ( ( theApp.ReleasedKeyPressed( VK_SPACE ) )
  ||   ( theApp.ReleasedKeyPressed( VK_RETURN ) )
  ||   ( theApp.ReleasedKeyPressed( VK_ESCAPE ) ) )
  {
    theApp.NextState( new CGSGame() );
  }
}



void CGSMenu::UpdateFixed()
{
  m_AnimFrame++;
  m_DisplayUnitDelay++;
  if ( m_DisplayUnitDelay >= 100 )
  {
    m_DisplayUnitDelay = 0;
    m_CurUnit = ( ( m_CurUnit + 1 ) % m_DisplayUnits.size() );
  }
}



void CGSMenu::OnMouse( int X, int Y, int Buttons )
{

}



void CGSMenu::OnChar( int iChar )
{

  if ( iChar == 'p' )
  {
    theApp.NextState( new CGSGame() );
  }
  else if ( iChar == 27 )
  {
    PostMessage( theApp.m_hWnd, WM_CLOSE, 0, 0 );
  }

}



void CGSMenu::OnKeyDown( int iChar )
{

}