#pragma once
#include "gamestate.h"

#include "LDTypes.h"

#include <list>



class CGSGame : public CGameState
{

  public:

    LD::Level               m_Level;

    std::list<LD::Unit>     m_FloorUnits;
    std::list<LD::Unit>     m_Units;
    std::list<LD::Unit>     m_FXUnits;

    LD::Unit*               m_pPlayer;

    int                     m_CurXP;
    int                     m_NextLevelAtXP;

    std::list<LD::Message>  m_Messages;

    int                     m_AnimFrame;


    CGSGame();
    virtual ~CGSGame();

    virtual void            Display( IDirect3DDevice8* pDevice );

    virtual void            UpdateFrame( const float fElapsedTime );
    virtual void            UpdateFixed();

    virtual void            OnChar( int iChar );
    virtual void            OnKeyDown( int iChar );
    virtual void            OnMouse( int X, int Y, int Buttons );

    void                    RestartGame();

    void                    Turn();
    LD::Unit*               UnitAt( int X, int Y );
    LD::Unit*               FloorUnitAt( int X, int Y );
    void                    RemoveFloorUnitAt( int X, int Y );

    LD::Unit*               SpawnRandomEnemyAt( int X, int Y );
    LD::Unit*               SpawnRandomEnemy();
    LD::Unit*               SpawnUnitAtRandomPos( LD::UnitType Type, int Level );
    LD::Unit*               SpawnUnit( int X, int Y, LD::UnitType Type, int Level );

    void                    Attack( LD::Unit& Attacker, LD::Unit& Target );

    void                    RenderUnit( LD::Unit& Unit, int X, int Y );

    LD::Unit*               AddSlime( int X, int Y, LD::UnitType Unit );
    void                    SlimeBonus( LD::UnitType Type, int X1, int Y1, int X2, int Y2, int X3, int Y3 );

};
