#include <d3d8.h>

#include ".\GSGame.h"
#include ".\GSDone.h"
#include ".\LD.h"

#include <vector>



CGSGame::CGSGame() :
  m_pPlayer( NULL )
{
  theApp.m_Music.LoadMusic( "sounds/ingame.ogg" );
  theApp.m_Music.Play( true );

  m_AnimFrame = 0;

  RestartGame();
}



CGSGame::~CGSGame()
{
}



void CGSGame::RestartGame()
{
  m_FloorUnits.clear();
  m_Units.clear();
  m_FXUnits.clear();
  m_Messages.clear();

  m_pPlayer = SpawnUnit( 0, 0, LD::UT_PLAYER, 1 );
  m_CurXP         = 0;
  m_NextLevelAtXP = 5;

  SpawnUnit( 9,9, LD::UT_BOSS, 20 );
  for ( int i = 0; i < 10; ++i )
  {
    SpawnRandomEnemy();
  }
  SpawnUnitAtRandomPos( LD::UT_CHEST, 1 );
  SpawnUnitAtRandomPos( LD::UT_CHEST, 1 );
}



void CGSGame::RenderUnit( LD::Unit& Unit, int X, int Y )
{
  int     imageOffset = 0;

  if ( ( Unit.Type == LD::UT_SLIME )
  ||   ( Unit.Type == LD::UT_SPIDER )
  ||   ( Unit.Type == LD::UT_BEAR )
  ||   ( Unit.Type == LD::UT_BOSS )
  ||   ( Unit.Type == LD::UT_OCTOPUS )
  ||   ( Unit.Type == LD::UT_CACODEMON )
  ||   ( Unit.Type == LD::UT_BAT )
  ||   ( Unit.Type == LD::UT_KITTEN )
  ||   ( Unit.Type == LD::UT_JELLY ) )
  {
    if ( ( m_AnimFrame ) % 32 >= 16 )
    {
      imageOffset = 1;
    }
  }
  theApp.RenderTextureSectionAsTile2d( X, Y, theApp.m_TexSec[Unit.Image + imageOffset] );

  switch ( Unit.Type )
  {
    case LD::UT_FX_DAMAGE:
    case LD::UT_FX_HEAL:
    case LD::UT_FX_EXP:
      {
        char    temp[5];
        sprintf( temp, "%d", Unit.DisplayValue );
        theApp.PrintNumberCentered( X + 16, Y + 12, temp );
      }
      break;
  }
}



void CGSGame::Display( IDirect3DDevice8* pDevice )
{

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

  for ( int i = 0; i < 10; ++i )
  {
    for ( int j = 0; j < 10; ++j )
    {
      theApp.RenderTextureSectionAsTile2d( i * 32, j * 32, theApp.m_TexSec[theApp.m_TileTexture[m_Level.Tiles[i][j].Type]] );
    }
  }

  std::list<LD::Unit>::iterator   itUF( m_FloorUnits.begin() );
  while ( itUF != m_FloorUnits.end() )
  {
    LD::Unit& unit( *itUF );

    RenderUnit( unit, unit.X, unit.Y );

    ++itUF;
  }
  std::list<LD::Unit>::iterator   itU( m_Units.begin() );
  while ( itU != m_Units.end() )
  {
    LD::Unit& unit( *itU );

    RenderUnit( unit, unit.X * 32, unit.Y * 32 );

    ++itU;
  }
  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
  theApp.m_pd3dDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

  std::list<LD::Unit>::iterator   itFU( m_FXUnits.begin() );
  while ( itFU != m_FXUnits.end() )
  {
    LD::Unit& unit( *itFU );

    RenderUnit( unit, unit.X, unit.Y );

    ++itFU;
  }

  if ( m_pPlayer )
  {
    char    temp[50];
    sprintf( temp, "XP: %d/%d LV: %d HP: %d", m_CurXP, m_NextLevelAtXP, m_pPlayer->Level, m_pPlayer->HP );
    theApp.PrintNumber( 2, 324, temp );
    sprintf( temp, "ATTACK: %d  WEAPON: %d", m_pPlayer->Attack, m_pPlayer->Weapon );
    theApp.PrintNumber( 2, 334, temp );
    sprintf( temp, "DEFENSE: %d  ARMOR: %d", m_pPlayer->Defense, m_pPlayer->Armor );
    theApp.PrintNumber( 2, 344, temp );
  }

  if ( !m_Messages.empty() )
  {
    theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
    theApp.m_pd3dDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
    theApp.m_pd3dDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

    theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
    theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

    theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
    theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
    theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

    theApp.RenderQuad2d( 40, 140, 240, 50, 0x809BD998 );

    theApp.PrintNumberCentered( 160, 150, m_Messages.front().Text[0].c_str() );
    theApp.PrintNumberCentered( 160, 160, m_Messages.front().Text[1].c_str() );
    theApp.PrintNumberCentered( 160, 170, m_Messages.front().Text[2].c_str() );
  }
}



LD::Unit* CGSGame::SpawnUnit( int X, int Y, LD::UnitType Type, int Level )
{
  LD::Unit    newUnit;

  newUnit.Type = Type;

  // default HP value is 50
  // default attack value is 10
  switch ( Type )
  {
    case LD::UT_PLAYER:
      newUnit.Image   = LD::TEX_UNIT_PLAYER;
      newUnit.HP      = 250; 
      newUnit.Attack  = 1;
      newUnit.TurnDelaySpeed = 100;
      break;
    case LD::UT_CHEST:
      newUnit.Image   = LD::TEX_CHEST;
      break;
    case LD::UT_SLIME:
      newUnit.Image   = LD::TEX_UNIT_SLIME;
      newUnit.HP      = 40; 
      newUnit.Attack  = 8;
      newUnit.TurnDelaySpeed = 40;
      break;
    case LD::UT_SPIDER:
      newUnit.Image   = LD::TEX_UNIT_SPIDER;
      newUnit.HP      = 70;
      newUnit.Attack  = 14;
      newUnit.TurnDelaySpeed = 110;
      break;
    case LD::UT_JELLY:
      newUnit.Image   = LD::TEX_UNIT_JELLY;
      newUnit.HP      = 150;
      newUnit.Attack  = 11;
      newUnit.TurnDelaySpeed = 50;
      break;
    case LD::UT_BEAR:
      newUnit.Image   = LD::TEX_UNIT_BEAR;
      newUnit.HP      = 250;
      newUnit.Attack  = 20;
      newUnit.TurnDelaySpeed = 70;
      break;
    case LD::UT_OCTOPUS:
      newUnit.Image   = LD::TEX_UNIT_OCTOPUS;
      newUnit.HP      = 280;
      newUnit.Attack  = 14;
      newUnit.TurnDelaySpeed = 50;
      break;
    case LD::UT_KITTEN:
      newUnit.Image   = LD::TEX_UNIT_KITTEN;
      newUnit.HP      = 350;
      newUnit.Attack  = 54;
      newUnit.TurnDelaySpeed = 110;
      break;
    case LD::UT_BAT:
      newUnit.Image   = LD::TEX_UNIT_BAT;
      newUnit.HP      = 400;
      newUnit.Attack  = 34;
      newUnit.TurnDelaySpeed = 140;
      break;
    case LD::UT_CACODEMON:
      newUnit.Image   = LD::TEX_UNIT_CACODEMON;
      newUnit.HP      = 600;
      newUnit.Attack  = 40;
      newUnit.TurnDelaySpeed = 70;
      break;
    case LD::UT_BOSS:
      newUnit.Image   = LD::TEX_UNIT_BOSS;
      newUnit.HP      = 2500;
      newUnit.Attack  = 200;
      newUnit.TurnDelaySpeed = 130;
      break;
  }
  newUnit.X = X;
  newUnit.Y = Y;
  newUnit.Level = Level;

  newUnit.HP = ( newUnit.HP * Level ) / 50;
  if ( newUnit.HP == 0 )
  {
    newUnit.HP = 1;
  }
  newUnit.Attack = ( newUnit.Attack * Level ) / 10;
  if ( newUnit.Attack == 0 )
  {
    newUnit.Attack = 1;
  }

  m_Units.push_back( newUnit );
  return &m_Units.back();
}



LD::Unit* CGSGame::UnitAt( int X, int Y )
{
  std::list<LD::Unit>::iterator   itU( m_Units.begin() );
  while ( itU != m_Units.end() )
  {
    LD::Unit& unit( *itU );

    if ( ( unit.X == X )
    &&   ( unit.Y == Y ) )
    {
      return &unit;
    }
    ++itU;
  }
  return NULL;
}



LD::Unit* CGSGame::FloorUnitAt( int X, int Y )
{
  std::list<LD::Unit>::iterator   itU( m_FloorUnits.begin() );
  while ( itU != m_FloorUnits.end() )
  {
    LD::Unit& unit( *itU );

    if ( ( unit.X == X )
    &&   ( unit.Y == Y ) )
    {
      return &unit;
    }
    ++itU;
  }
  return NULL;
}



LD::Unit* CGSGame::SpawnRandomEnemyAt( int X, int Y )
{
  std::vector<LD::UnitType>     units;

  units.push_back( LD::UT_SLIME );
  units.push_back( LD::UT_SPIDER );
  units.push_back( LD::UT_JELLY );
  units.push_back( LD::UT_BEAR );
  units.push_back( LD::UT_OCTOPUS );
  units.push_back( LD::UT_KITTEN );
  units.push_back( LD::UT_BAT );
  units.push_back( LD::UT_CACODEMON );

  int     maxLevel = m_pPlayer->Level + 1;
  if ( maxLevel > (int)units.size() )
  {
    maxLevel = (int)units.size();
  }
  int   randUnit = rand() % maxLevel;
  int   enemyLevel = 1 + randUnit;

  return SpawnUnit( X, Y, units[randUnit], enemyLevel );
}



LD::Unit* CGSGame::SpawnRandomEnemy()
{
  int     randX = 0;
  int     randY = 0;

  for ( int i = 0; i < 5; ++i )
  {
    randX = rand() % 10;
    randY = rand() % 10;

    if ( UnitAt( randX, randY ) == NULL )
    {
      return SpawnRandomEnemyAt( randX, randY );
    }
  }
  return NULL;
}



LD::Unit* CGSGame::SpawnUnitAtRandomPos( LD::UnitType Type, int Level )
{
  int     randX = 0;
  int     randY = 0;

  while ( true )
  {
    randX = rand() % 10;
    randY = rand() % 10;

    if ( UnitAt( randX, randY ) == NULL )
    {
      return SpawnUnit( randX, randY, Type, Level );
    }
  }
}



void CGSGame::Turn()
{
  if ( rand() % 100 >= 75 )
  {
    // spawn new enemy
    SpawnRandomEnemy();
  }
  if ( rand() % 100 >= 97 )
  {
    SpawnUnitAtRandomPos( LD::UT_CHEST, m_pPlayer->Level );
  }
  // units move
  std::list<LD::Unit>::iterator   itU( m_Units.begin() );
  while ( itU != m_Units.end() )
  {
    LD::Unit& unit( *itU );

    if ( unit.RemoveMe )
    {
      if ( &unit == m_pPlayer )
      {
        m_pPlayer = NULL;

        theApp.PlaySoundA( LD::SOUND_PLAYER_KILLED );
        m_Messages.push_back( LD::Message( "YOU ARE DEAD", "", "PRESS SPACE TO RESTART" ) );
      }
      itU = m_Units.erase( itU );
      continue;
    }
    if ( ( unit.Type == LD::UT_PLAYER )
    ||   ( unit.Type == LD::UT_CHEST ) )
    {
      ++itU;
      continue;
    }

    unit.TurnDelayPos += unit.TurnDelaySpeed;
    if ( unit.TurnDelayPos >= 100 )
    {
      unit.TurnDelayPos = 0;

      // unit moves
      // TODO attack or move

      if ( m_pPlayer )
      {
        // check if player is nearby
        if ( std::abs( unit.X - m_pPlayer->X ) + std::abs( unit.Y - m_pPlayer->Y ) == 1 )
        {
          // TODO attack chance
          int     attackChance = 80;
          if ( rand() % 100 < attackChance )
          {
            Attack( unit, *m_pPlayer );
          }
        }
      }
    }
    ++itU;
  }
  itU = m_Units.begin();
  while ( itU != m_Units.end() )
  {
    LD::Unit& unit( *itU );

    if ( unit.RemoveMe )
    {
      if ( &unit == m_pPlayer )
      {
        m_pPlayer = NULL;
        theApp.PlaySoundA( LD::SOUND_PLAYER_KILLED );
        m_Messages.push_back( LD::Message( "YOU ARE DEAD", "", "PRESS SPACE TO RESTART" ) );
      }
      itU = m_Units.erase( itU );
      continue;
    }
    ++itU;
  }
}



void CGSGame::SlimeBonus( LD::UnitType Type, int X1, int Y1, int X2, int Y2, int X3, int Y3 )
{
  switch ( Type )
  {
    case LD::UT_FLOOR_SLIME_GREEN:
      m_Messages.push_back( LD::Message( "PURPLE MAGIC", "", "YOU ARE FULLY HEALED" ) );
      m_pPlayer->HP = ( 250 * m_pPlayer->Level ) / 50 + m_pPlayer->HPBonus;
      break;
    case LD::UT_FLOOR_SLIME_YELLOW:
      {
        char  temp[50];
        sprintf( temp, "ATTACK +%d", m_pPlayer->Level );
        m_Messages.push_back( LD::Message( "YELLOW MAGIC", "", temp ) );
        m_pPlayer->Attack += m_pPlayer->Level;
      }
      break;
    case LD::UT_FLOOR_SLIME_BLUE:
      {
        char  temp[50];
        sprintf( temp, "DEFENSE +%d", m_pPlayer->Level );
        m_Messages.push_back( LD::Message( "BLUE MAGIC", "", temp ) );
        m_pPlayer->Defense += m_pPlayer->Level;
      }
      break;
    case LD::UT_FLOOR_SLIME_RED:
      {
        char  temp[50];
        sprintf( temp, "MAX HP +%d", m_pPlayer->Level );
        m_Messages.push_back( LD::Message( "RED MAGIC", "", temp ) );
        m_pPlayer->HPBonus += m_pPlayer->Level;
      }
      break;
  }
  RemoveFloorUnitAt( X1, Y1 );
  RemoveFloorUnitAt( X2, Y2 );
  RemoveFloorUnitAt( X3, Y3 );

  theApp.PlaySoundA( LD::SOUND_MAGIC );
}



void CGSGame::RemoveFloorUnitAt( int X, int Y )
{
  // remove old floor unit
  std::list<LD::Unit>::iterator   itU( m_FloorUnits.begin() );
  while ( itU != m_FloorUnits.end() )
  {
    LD::Unit& unit( *itU );

    if ( ( unit.X == X * 32 )
    &&   ( unit.Y == Y * 32 ) )
    {
      m_FloorUnits.erase( itU );
      return;
    }
    ++itU;
  }
}



LD::Unit* CGSGame::AddSlime( int X, int Y, LD::UnitType Unit )
{
  // remove old floor unit
  RemoveFloorUnitAt( X, Y );

  LD::Unit    unitFloor;

  unitFloor.X = X * 32;
  unitFloor.Y = Y * 32;
  unitFloor.Type = Unit;

  switch ( Unit )
  {
    case LD::UT_FLOOR_SLIME_BLUE:
      unitFloor.Image = LD::TEX_SLIME_BLUE;
      break;
    case LD::UT_FLOOR_SLIME_RED:
      unitFloor.Image = LD::TEX_SLIME_RED;
      break;
    case LD::UT_FLOOR_SLIME_GREEN:
      unitFloor.Image = LD::TEX_SLIME_GREEN;
      break;
    case LD::UT_FLOOR_SLIME_YELLOW:
      unitFloor.Image = LD::TEX_SLIME_YELLOW;
      break;
  }
  m_FloorUnits.push_back( unitFloor );

  if ( m_pPlayer->RemoveMe )
  {
    return &m_FloorUnits.back();;
  }
  // TODO - check for 3 in a row
  for ( int x = 0; x < 10; ++x )
  {
    for ( int y = 0; y < 10; ++y )
    {
      LD::Unit*     pFloorUnits[3][3];
      for ( int i = -1; i <= 1; ++i )
      {
        for ( int j = -1; j <= 1; ++j )
        {
          pFloorUnits[i + 1][j + 1] = FloorUnitAt( ( x + i ) * 32, ( y + j ) * 32 );
        }
      }
      if ( ( pFloorUnits[0][0] )
      &&   ( pFloorUnits[1][1] )
      &&   ( pFloorUnits[2][2] ) )
      {
        // check diagonal
        if ( ( pFloorUnits[0][0]->Type == pFloorUnits[1][1]->Type )
        &&   ( pFloorUnits[2][2]->Type == pFloorUnits[1][1]->Type ) )
        {
          // 
          SlimeBonus( Unit, x - 1, y - 1, x, y, x + 1, y + 1 );
        }
      }
      if ( ( pFloorUnits[0][2] )
      &&   ( pFloorUnits[1][1] )
      &&   ( pFloorUnits[2][0] ) )
      {
        // check diagonal
        if ( ( pFloorUnits[0][2]->Type == pFloorUnits[1][1]->Type )
        &&   ( pFloorUnits[2][0]->Type == pFloorUnits[1][1]->Type ) )
        {
          // 
          SlimeBonus( Unit, x - 1, y + 1, x, y, x + 1, y - 1 );
        }
      }
      if ( ( pFloorUnits[1][0] )
      &&   ( pFloorUnits[1][1] )
      &&   ( pFloorUnits[1][2] ) )
      {
        // check vertical
        if ( ( pFloorUnits[1][0]->Type == pFloorUnits[1][1]->Type )
        &&   ( pFloorUnits[1][2]->Type == pFloorUnits[1][1]->Type ) )
        {
          // 
          SlimeBonus( Unit, x, y - 1, x, y, x, y + 1 );
        }
      }
      if ( ( pFloorUnits[0][1] )
      &&   ( pFloorUnits[1][1] )
      &&   ( pFloorUnits[2][1] ) )
      {
        // check horz
        if ( ( pFloorUnits[0][1]->Type == pFloorUnits[1][1]->Type )
        &&   ( pFloorUnits[2][1]->Type == pFloorUnits[1][1]->Type ) )
        {
          // 
          SlimeBonus( Unit, x - 1, y, x, y, x + 1, y );
        }
      }
    }
  }
  return &m_FloorUnits.back();
}



void CGSGame::Attack( LD::Unit& Attacker, LD::Unit& Target )
{
  // TODO - weapons/strength
  int     attackPower = Attacker.Attack + Attacker.Weapon;

  int     fumbleChance = 20;
  int     criticalChance = 10;
  if ( rand() % 100 < fumbleChance )
  {
    attackPower = 0;
  }
  int     defenseChance = Target.Defense;
  int     defensePower = Target.Armor;
  int     fumbleChanceTarget = 20;
  if ( rand() % 100 < fumbleChanceTarget )
  {
    defensePower = 0;
  }
  if ( rand() % 100 < defenseChance )
  {
    attackPower = 0;
  }
  bool criticalHit = ( rand() % 100 < criticalChance );
  if ( criticalHit )
  {
    attackPower *= 2;
  }
  if ( ( rand() % 100 < defenseChance )
  &&   ( !criticalHit ) )
  {
    // defended
    attackPower = 0;
  }

  if ( defensePower > attackPower )
  {
    // armor defended
    attackPower = 0;
  }

  int damage = 0;
  if ( attackPower > 0 )
  {
    damage = attackPower - defensePower;
    if ( damage >= Target.HP )
    {
      theApp.PlaySoundA( LD::SOUND_ENEMY_KILLED );
      Target.RemoveMe = true;
      //damage = Target.HP;

      int     experience = Target.Level;

      switch ( Target.Type )
      {
        case LD::UT_SLIME:
        case LD::UT_OCTOPUS:
          AddSlime( Target.X, Target.Y, LD::UT_FLOOR_SLIME_GREEN );
          break;
        case LD::UT_SPIDER:
        case LD::UT_KITTEN:
          AddSlime( Target.X, Target.Y, LD::UT_FLOOR_SLIME_YELLOW );
          break;
        case LD::UT_JELLY:
        case LD::UT_BAT:
          AddSlime( Target.X, Target.Y, LD::UT_FLOOR_SLIME_BLUE );
          break;
        case LD::UT_BEAR:
        case LD::UT_CACODEMON:
        case LD::UT_PLAYER:
          AddSlime( Target.X, Target.Y, LD::UT_FLOOR_SLIME_RED );
          break;
      }

      if ( m_pPlayer == &Attacker )
      {
        if ( Target.Type == LD::UT_BOSS )
        {
          theApp.NextState( new CGSDone() );
        }
        LD::Unit    unitFX;

        unitFX.X = Attacker.X * 32;
        unitFX.Y = Attacker.Y * 32;
        unitFX.Type = LD::UT_FX_EXP;
        unitFX.Image = LD::TEX_FX_EXP;
        unitFX.DisplayValue = experience;
        unitFX.LifeTime = 20;

        m_FXUnits.push_back( unitFX );

        m_CurXP += experience;
        while ( m_CurXP >= m_NextLevelAtXP )
        {
          // level up
          m_pPlayer->Level++;

          // scales HP with level
          //m_pPlayer->HP = ( ( m_pPlayer->HP * 50 / ( m_pPlayer->Level - 1 ) ) * m_pPlayer->Level ) / 50;
          m_pPlayer->HP = ( 250 * m_pPlayer->Level ) / 50 + m_pPlayer->HPBonus;

          m_NextLevelAtXP += m_pPlayer->Level * 5;

          int     attackBonus = 1 + rand() % m_pPlayer->Level;
          int     defenseBonus = 1 + rand() % m_pPlayer->Level;

          char    temp1[50];
          char    temp2[50];

          sprintf( temp1, "ATTACK +%d", attackBonus );
          sprintf( temp2, "DEFENSE +%d", defenseBonus );

          m_Messages.push_back( LD::Message( "LEVEL UP!", temp1, temp2 ) );

          m_pPlayer->Attack += attackBonus;
          m_pPlayer->Defense += defenseBonus;

          theApp.PlaySoundA( LD::SOUND_LEVEL_UP );
        }

        if ( Target.Type == LD::UT_CHEST )
        {
          theApp.PlaySoundA( LD::SOUND_OPEN_CHEST );
          switch ( rand() % 6 )
          {
            case 0:
              m_Messages.push_back( LD::Message( "YOU FOUND A POTION", "", "YOU ARE FULLY HEALED" ) );
              m_pPlayer->HP = ( 250 * m_pPlayer->Level ) / 50 + m_pPlayer->HPBonus;
              break;
            case 1:
              {
                char  temp[50];
                sprintf( temp, "DEFENSE +%d", m_pPlayer->Level );
                m_Messages.push_back( LD::Message( "YOU FOUND A NEW ARMOR", "", temp ) );
                m_pPlayer->Defense += m_pPlayer->Level;
              }
              break;
            case 2:
              {
                char  temp[50];
                sprintf( temp, "ATTACK +%d", m_pPlayer->Level );
                m_Messages.push_back( LD::Message( "YOU FOUND A NEW WEAPON", "", temp ) );
                m_pPlayer->Attack += m_pPlayer->Level;
              }
              break;
            case 3:
              m_Messages.push_back( LD::Message( "YOU TRIGGER A TRAP", "", "YOUR HEALTH IS HALVED" ) );
              m_pPlayer->HP /= 2;
              if ( m_pPlayer->HP == 0 )
              {
                m_pPlayer->RemoveMe = true;
              }
              break;
            case 4:
              m_Messages.push_back( LD::Message( "", "THE CHEST IS EMPTY", "" ) );
              break;
            case 5:
              {
                char  temp[50];
                sprintf( temp, "MAX HP +%d", m_pPlayer->Level );
                m_Messages.push_back( LD::Message( "YOU FOUND A SPELL SCROLL", "", temp ) );
                m_pPlayer->HPBonus += m_pPlayer->Level;
              }
              break;
          }
        }
      }
    }
    else
    {
      Target.HP -= damage;

      if ( &Attacker == m_pPlayer )
      {
        theApp.PlaySoundA( (LD::SoundTypes)( LD::SOUND_PLAYER_ATTACK_1 + rand() % 3 ) );
      }
      else
      {
        theApp.PlaySoundA( (LD::SoundTypes)( LD::SOUND_ENEMY_ATTACK_1 + rand() % 3 ) );
      }
    }
  }
  else
  {
    theApp.PlaySoundA( LD::SOUND_MISS );
  }

  LD::Unit    unitDamage;

  unitDamage.X = Target.X * 32;
  unitDamage.Y = Target.Y * 32;
  unitDamage.Type = LD::UT_FX_DAMAGE;
  unitDamage.Image = LD::TEX_FX_DAMAGE;
  unitDamage.DisplayValue = -damage;
  unitDamage.LifeTime = 20;

  m_FXUnits.push_back( unitDamage );
}



void CGSGame::UpdateFixed()
{
  m_AnimFrame++;

  std::list<LD::Unit>::iterator   itU( m_FXUnits.begin() );
  while ( itU != m_FXUnits.end() )
  {
    LD::Unit& unit( *itU );

    if ( unit.LifeTime > 0 )
    {
      --unit.LifeTime;
      if ( unit.LifeTime == 0 )
      {
        unit.RemoveMe = true;
      }
    }
    switch ( unit.Type )
    {
      case LD::UT_FX_DAMAGE:
      case LD::UT_FX_HEAL:
      case LD::UT_FX_EXP:
        unit.Y--;
        break;
    }
    if ( unit.RemoveMe )
    {
      itU = m_FXUnits.erase( itU );
    }
    else
    {
      ++itU;
    }
  }

}



void CGSGame::UpdateFrame( const float fElapsedTime )
{
  if ( !m_Messages.empty() )
  {
    if ( m_pPlayer == NULL )
    {
      if ( ( theApp.ReleasedKeyPressed( VK_SPACE ) )
      ||   ( theApp.ReleasedKeyPressed( VK_RETURN ) )
      ||   ( theApp.ReleasedKeyPressed( VK_ESCAPE ) ) )
      {
        m_Messages.clear();
        RestartGame();
      }
      if ( m_Messages.size() == 1 )
      {
        return;
      }
    }
    if ( ( theApp.ReleasedKeyPressed( VK_SPACE ) )
    ||   ( theApp.ReleasedKeyPressed( VK_RETURN ) )
    ||   ( theApp.ReleasedKeyPressed( VK_ESCAPE ) ) )
    {
      m_Messages.pop_front();
    }
    return;
  }

  if ( theApp.ReleasedKeyPressed( VK_LEFT ) )
  {
    if ( m_pPlayer->X > 0 )
    {
      LD::Unit*  pTarget = UnitAt( m_pPlayer->X - 1, m_pPlayer->Y );
      if ( pTarget != NULL )
      {
        Attack( *m_pPlayer, *pTarget );
      }
      else
      {
        --m_pPlayer->X;
        theApp.PlaySoundA( LD::SOUND_STEP );
      }
      Turn();
    }
  }
  if ( theApp.ReleasedKeyPressed( VK_RIGHT ) )
  {
    if ( m_pPlayer->X < 9 )
    {
      LD::Unit*  pTarget = UnitAt( m_pPlayer->X + 1, m_pPlayer->Y );
      if ( pTarget != NULL )
      {
        Attack( *m_pPlayer, *pTarget );
      }
      else
      {
        ++m_pPlayer->X;
        theApp.PlaySoundA( LD::SOUND_STEP );
      }
      Turn();
    }
  }
  if ( theApp.ReleasedKeyPressed( VK_UP ) )
  {
    if ( m_pPlayer->Y > 0 )
    {
      LD::Unit*  pTarget = UnitAt( m_pPlayer->X, m_pPlayer->Y - 1 );
      if ( pTarget != NULL )
      {
        Attack( *m_pPlayer, *pTarget );
      }
      else
      {
        --m_pPlayer->Y;
        theApp.PlaySoundA( LD::SOUND_STEP );
      }
      Turn();
    }
  }
  if ( theApp.ReleasedKeyPressed( VK_DOWN ) )
  {
    if ( m_pPlayer->Y < 9 )
    {
      LD::Unit*  pTarget = UnitAt( m_pPlayer->X, m_pPlayer->Y + 1 );
      if ( pTarget != NULL )
      {
        Attack( *m_pPlayer, *pTarget );
      }
      else
      {
        ++m_pPlayer->Y;
        theApp.PlaySoundA( LD::SOUND_STEP );
      }
      Turn();
    }
  }
}



void CGSGame::OnMouse( int X, int Y, int Buttons )
{

}



void CGSGame::OnChar( int iChar )
{

  if ( iChar == 'p' )
  {
    //theApp.NextState( new CGSGame() );
  }
  else if ( iChar == 'i' )
  {
    //theApp.NextState( new CGSInstructions() );
  }
  else if ( iChar == 27 )
  {
    PostMessage( theApp.m_hWnd, WM_CLOSE, 0, 0 );
  }

}



void CGSGame::OnKeyDown( int iChar )
{

}