#include <Xtreme/XRenderer.h>

#include ".\BirdiesRevenge.h"
#include ".\Thing.h"



Thing::Thing()
{
  m_Type = Birdie2::UT_THING;

  m_SproingPos = 0;
  m_IsNasty = true;

  m_WalkSpeed = 3;

  m_MovementBounds.set( 0, 0, 40, 40 );
  m_CollisionBounds.set( 5, 5, 30, 30 );

  SetImage( "Thing.1" );
}



void Thing::UpdateFixed( Level& Level )
{
  if ( m_OnGround )
  {
    ++m_SproingPos;
    if ( ( m_SproingPos == 8 )
    ||   ( m_SproingPos == 24 ) )
    {
      SetImage( "Thing.2" );
    }
    else if ( m_SproingPos == 16 )
    {
      SetImage( "Thing.3" );
    }
    else if ( m_SproingPos == 32 )
    {
      SetImage( "Thing.1" );
      Jump( 18 );
      m_SproingPos = 0;
      theApp.SoundClass()->Play( theApp.Sound( "Spring.Jump" ) );
    }
  }
  Unit::UpdateFixed( Level );
}



void Thing::Update( Level& Level, const GR::f32 fElapsedTime )
{
  if ( m_OnGround )
  {
    m_Speed.x = 0;
  }
  else
  {
    if ( m_FaceLeft )
    {
      m_Speed.x = -m_WalkSpeed;
    }
    else
    {
      m_Speed.x = m_WalkSpeed;
    }
  }
  Unit::Update( Level, fElapsedTime );
}



void Thing::ProcessEvent( Level& Level, const eUnitEvent& Event )
{
  Unit::ProcessEvent( Level, Event );

  switch ( Event )
  {
    case ET_BLOCKED_LEFT:
      m_FaceLeft = false;
      break;
    case ET_BLOCKED_RIGHT:
      m_FaceLeft = true;
      break;
    case ET_BLOCKED_UP:
      break;
    case ET_BLOCKED_DOWN:
      break;
    case ET_FALL_START:
      break;
    case ET_FALL_END:
      m_Speed.x = 0;
      break;
  }
}