#include <Xtreme/XRenderer.h>

#include ".\BirdiesRevenge.h"
#include ".\Pumpkin.h"
#include ".\Level.h"



Pumpkin::Pumpkin()
{
  m_Type = Birdie2::UT_PUMPKIN;

  m_IsNasty = true;
  m_Floating = true;
  m_Angle = 0.0;
  m_OffsetFromCenter = 0.0f;

  m_WalkSpeed = 3;

  m_MovementBounds.set( 0, 0, 80, 80 );
  m_CollisionBounds.set( 10, 10, 60, 60 );

  m_HP = 30;
  m_ShotDelay = 0;
  m_ShotType = true;
  m_FaceLeft = true;

  SetAnimation( "Pumpkin" );
}



void Pumpkin::UpdateFixed( Level& Level )
{
  ++m_ShotDelay;
  if ( m_ShotDelay >= 50 )
  {
    m_ShotDelay -= 50;
    m_ShotType = !m_ShotType;

    if ( m_ShotType )
    {
      Unit*   pShot = Level.SpawnUnit( m_Position.x, m_Position.y, Birdie2::UT_BOSS_SHOT );
      pShot->m_Speed.set( -5, -5 );

      pShot = Level.SpawnUnit( m_Position.x, m_Position.y, Birdie2::UT_BOSS_SHOT );
      pShot->m_Speed.set( 5, -5 );
      pShot = Level.SpawnUnit( m_Position.x, m_Position.y, Birdie2::UT_BOSS_SHOT );
      pShot->m_Speed.set( -5, 5 );
      pShot = Level.SpawnUnit( m_Position.x, m_Position.y, Birdie2::UT_BOSS_SHOT );
      pShot->m_Speed.set( 5, 5 );
    }
    else
    {
      Unit*   pShot = Level.SpawnUnit( m_Position.x, m_Position.y, Birdie2::UT_BOSS_SHOT );
      pShot->m_Speed.set( -5, 0 );

      pShot = Level.SpawnUnit( m_Position.x, m_Position.y, Birdie2::UT_BOSS_SHOT );
      pShot->m_Speed.set( 5, 0 );
      pShot = Level.SpawnUnit( m_Position.x, m_Position.y, Birdie2::UT_BOSS_SHOT );
      pShot->m_Speed.set( 0, 5 );
      pShot = Level.SpawnUnit( m_Position.x, m_Position.y, Birdie2::UT_BOSS_SHOT );
      pShot->m_Speed.set( 0, -5 );
    }
  }
  Unit::UpdateFixed( Level );
}



void Pumpkin::Update( Level& Level, const GR::f32 ElapsedTime )
{
  m_Angle += 90.0f * ElapsedTime;

  m_OffsetFromCenter = math::minValue( m_OffsetFromCenter + 0.25f * ElapsedTime, 1.0f );

  GR::tFPoint     offset( 160.0f * m_OffsetFromCenter, 0.0f );

  offset.RotateZ( m_Angle );

  m_Position = m_StartPosition + GR::tPoint( (int)offset.x, (int)offset.y );

  Unit::Update( Level, ElapsedTime );
}



void Pumpkin::ProcessEvent( Level& Level, const eUnitEvent& Event )
{
  Unit::ProcessEvent( Level, Event );

  switch ( Event )
  {
    case ET_BLOCKED_LEFT:
      break;
    case ET_BLOCKED_RIGHT:
      break;
    case ET_BLOCKED_UP:
      break;
    case ET_BLOCKED_DOWN:
      break;
    case ET_FALL_START:
      break;
    case ET_FALL_END:
      break;
  }
}



void Pumpkin::OnLoad( Level& Level )
{
  Unit::OnLoad( Level );
}