#include <Xtreme/XRenderer.h>

#include ".\BirdiesRevenge.h"
#include ".\Points.h"
#include ".\Level.h"



Points::Points()
{
  m_Type = Birdie2::UT_POINTS;

  m_MovementBounds.set( 0, 0, 40, 40 );
  m_CollisionBounds.set( 0, 0, 40, 40 );

  m_Floating   = true;

  m_LifeTime   = 4.0f;

  m_Speed.y     = -2;
  m_YSpeed      = -30;

  m_XPos        = 0.0f;
}



void Points::Display( const GR::tPoint& ptOffset, XRenderer& Renderer )
{
  theApp.PrintTextCentered( m_Position.x - ptOffset.x, m_Position.y - ptOffset.y, m_Points );
}



void Points::Update( Level& Level, const GR::f32 ElapsedTime )
{
  if ( m_Position.y < -20 )
  {
    m_RemoveMe = true;
  }

  m_XPos += ElapsedTime;
  m_Position.x = m_StartPosition.x + (int)( 40.0f * sinf( 3.1415926f / 180.0f * m_XPos * 270.0f ) );
  Unit::Update( Level, ElapsedTime );
}



void Points::ProcessEvent( Level& Level, const eUnitEvent& Event )
{
  switch ( Event )
  {
    case Unit::ET_BLOCKED_LEFT:
      break;
    case Unit::ET_BLOCKED_RIGHT:
      break;
    case Unit::ET_BLOCKED_UP:
      break;
    case Unit::ET_BLOCKED_DOWN:
      break;
    case Unit::ET_INIT:
      break;
  }
  Unit::ProcessEvent( Level, Event );
}



