#include <Xtreme/XRenderer.h>

#include ".\BirdiesRevenge.h"
#include ".\Note.h"
#include ".\Level.h"



Note::Note()
{
  m_Type = Birdie2::UT_NOTE;

  m_MovementBounds.set( 8, 9, 26, 26 );
  m_CollisionBounds.set( 8, 9, 26, 26 );

  m_FlownDistance = 0;
  m_WalkSpeed = 7;
  m_Floating = true;
  m_Rising = false;
  m_DistanceToFly = 240;

  m_IsPlatform = true;

  SetAnimation( "Note" );
}



void Note::UpdateFixed( Level& Level )
{
  if ( !m_Rising )
  {
    m_FlownDistance += m_WalkSpeed;
    if ( m_FlownDistance >= m_DistanceToFly )
    {
      Rise();
    }
  }
  Unit::UpdateFixed( Level );
}



void Note::Update( Level& Level, const GR::f32 fElapsedTime )
{
  if ( !m_Rising )
  {
    if ( m_FaceLeft )
    {
      m_Speed.x = -m_WalkSpeed;
    }
    else
    {
      m_Speed.x = m_WalkSpeed;
    }
  }
  Unit::Update( Level, fElapsedTime );
}



void Note::Rise()
{
  m_Rising = true;
  m_Speed.y = -2;
  m_Speed.x = 0;
}



void Note::ProcessEvent( Level& Level, const eUnitEvent& Event )
{
  Unit::ProcessEvent( Level, Event );

  switch ( Event )
  {
    case ET_BLOCKED_LEFT:
      Rise();
      break;
    case ET_BLOCKED_RIGHT:
      Rise();
      break;
    case ET_BLOCKED_UP:
      {
        m_RemoveMe = true;

        Unit*    pPop = Unit::FromType( Birdie2::UT_POP );
        pPop->m_Position = m_Position;

        Level.m_Units.push_back( pPop );

        theApp.SoundClass()->Play( theApp.Sound( "Pop" ) );
      }
      break;
    case ET_FALL_START:
      break;
    case ET_FALL_END:
      break;
    case ET_MOVED_LEFT:
      MoveCarriedUnits( Level, -1, 0 );
      break;
    case ET_MOVED_RIGHT:
      MoveCarriedUnits( Level, 1, 0 );
      break;
    case ET_MOVED_UP:
      MoveCarriedUnits( Level, 0, -1 );
      break;
    case ET_MOVED_DOWN:
      MoveCarriedUnits( Level, 0, 1 );
      break;
  }

}



